package tests::RobotCategoriserTest;

use strict;

use base qw/Lire::Test::DlfAnalyserTestCase/;

use Lire::DlfAnalysers::RobotCategoriser;
use File::Basename;

sub schemasdir {
    return dirname( __FILE__ ) . "/../..";
}

sub create_analyser {
    return new Lire::DlfAnalysers::RobotCategoriser();
}

sub registration_file {
    return dirname( __FILE__ ) . "/../../www-robot_init";
}

sub test_categorise {
    my $self = $_[0];

    my $analyser = $self->create_analyser();
    $analyser->initialise();
    $self->assert_isa( 'Lire::WWW::UserAgent', $analyser->{'ua_analyser'} );
    $self->assert_isa( 'Lire::WWW::Domain', $analyser->{'domain_analyser'} );

    my $dlf = { 'client_host' => undef,
                'useragent' => undef,
              };
    $analyser->categorise( $dlf );
    $self->assert_null( $dlf->{'robot'} );

    $dlf->{'client_host'} = '192.168.250.1';
    $dlf->{'useragent'} = 'unknown robot';
    $analyser->categorise( $dlf );
    $self->assert_null( $dlf->{'robot'} );

    $dlf->{'useragent'} = 'websnarf';
    $analyser->categorise( $dlf );
    $self->assert_str_equals( 'Websnarf', $dlf->{'robot'} );

    $dlf->{'client_host'} = 'g101.googlebot.com';
    $analyser->categorise( $dlf );
    $self->assert_str_equals( 'Google (http://www.google.com/)',
                              $dlf->{'robot'} );

    return;
}


1;
