<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/

/*
* This class deals with module navigation tool.  It define which modules should be loaded
* and print navigation bar
*
* Author: Nicolas Dufresne
*/

require_once 'modules-config.php';
require_once 'entityRole-config.php';
require_once 'roles-config.php';
require_once 'functions.php';



class ModulesBrowser{
	var $currentModule;

	function ModulesBrowser() {
		global $MODULES,$termonly,$ROLE;
		// Checking if a module is selected
		if (!isset($_GET['module']) || !isset($MODULES[$_GET['module']])) {
			// If not, select first in list
			foreach ($ROLE[$_SESSION['userRole']] as $index => $name) {
				$this->currentModule = $name;
				break;
			}
		} else
			$this->currentModule = $_GET['module'];

		// Loading module if role has permission to ...
		if(in_array($this->currentModule, $ROLE[$_SESSION['userRole']])){
			$module_action = "build";
			include $MODULES[$this->currentModule];
		}

		// Printing module navigator
		$this->printBrowser();
		echo "<div class='content'>";
		// Printing module
		$module_action = "print";
		include $MODULES[$this->currentModule];
		echo "</div>";
	}

	function printBrowser() {
		global $MODULES,$termonly,$termonly_modules,$ROLE,$GROUP_ROLE;
		echo "<a href='/ltsp-cluster-control/Admin'><h2>LTSP-Cluster Control Center</h2></a>";
		echo "<ul id='menu_list'>";
		//foreach ($MODULES as $name => $file) {
		foreach ($ROLE[$_SESSION['userRole']] as $index => $name) {
			$_GET['module'] = $name;
			if($termonly) {
				//if(($name!="logs_module") && ($name!="configuration_module"))
				if(!(is_array($termonly_modules) && in_array($name, $termonly_modules)))
					continue;
			}
			echo "<li><a href='admin.php?".getGETParam()."' title='".getMessage($name)."'";
			if ($name == $this->currentModule) echo "id='chosen'";
			echo ">";
			echo getMessage($name."_short")."</a></li>";
		}
		$_GET['module'] = $this->currentModule;
		echo "</ul>";
		echo  "<h1>";
			echo getMessage($_GET['module']);
			$image = "./images/".$_GET['module'].".png";
			if( file_exists( $image ) ) echo "<img src='".$image."' alt='' title='' />";
		echo "</h1>";
		//if(!$termonly) echo "<HR SIZE='4' noshade width='100%'>";
	}
}
?>