#!/usr/bin/perl -w

use strict;
use warnings;
use lib qw(../perl/blib/arch ../perl);
use Test::More tests=>90;
use Buffy;

#
# Test Config
#

my $config = Buffy::Config->new("test-config.txt");
ok(defined $config);

ok(!$config->view()->read());
ok(!$config->view()->empty());
ok($config->view()->important());
is($config->general()->interval(), 600);

my $locations = $config->locations();
is($locations->size(), 4);

my $programs = $config->mailPrograms();
is($programs->size(), 3);

is($config->selectedMailProgram()->name(), "mutt");

$config->selectMailProgram("Test");
is($config->selectedMailProgram()->name(), "Test");

my $folder = Buffy::MailFolder::accessFolder("maildir/empty");
ok($folder->valid);
$config->mailProgram("test")->run($folder);

my $folder = $config->folder("foo");
ok($folder->forceview());
ok(!$folder->forcehide());
$folder->setForceHide(1);
ok(!$folder->forceview());
ok($folder->forcehide());

my $folder = $config->folder("bar");
ok(!$folder->forceview());
ok($folder->forcehide());
$folder->setForceView(1);
ok($folder->forceview());
ok(!$folder->forcehide());

#
# Test Maildir
#
my $test;
my $folders;

# Check an empty maildir
$test = Buffy::MailFolder::accessFolder("maildir/empty");
ok($test->valid);
is($test->name(), "empty");
is($test->path(), "maildir/empty");
is($test->type(), "Maildir");

is($test->getMsgTotal(), -1);
is($test->getMsgUnread(), -1);
is($test->getMsgNew(), -1);
is($test->getMsgFlagged(), -1);
ok($test->changed());

$test->updateStatistics();
is($test->getMsgTotal(), 0);
is($test->getMsgUnread(), 0);
is($test->getMsgNew(), 0);
is($test->getMsgFlagged(), 0);
ok(!$test->changed());

$folders = Buffy::MailFolder::enumerateFolders("maildir/empty");
is(scalar(@$folders), 1);

# Check a non empty maildir
$test = Buffy::MailFolder::accessFolder("maildir/test");
ok($test->valid());
is($test->name(), "test");
is($test->path(), "maildir/test");
is($test->type(), "Maildir");

is($test->getMsgTotal(), -1);
is($test->getMsgUnread(), -1);
is($test->getMsgNew(), -1);
is($test->getMsgFlagged(), -1);
ok($test->changed());

$test->updateStatistics();
is($test->getMsgTotal(), 3);
is($test->getMsgUnread(), 0);
is($test->getMsgNew(), 0);
is($test->getMsgFlagged(), 1);
ok(!$test->changed());

$folders = Buffy::MailFolder::enumerateFolders("maildir/test");
is(scalar(@$folders), 1);

# Check a maildir whose root is a broken symlink
$test = Buffy::MailFolder::accessFolder("maildir/broken");
ok(!$test->valid());

$folders = Buffy::MailFolder::enumerateFolders("maildir/broken");
is(scalar(@$folders), 0);

# Check a maildir whose cur, new and tmp directories are broken symlinks
$test = Buffy::MailFolder::accessFolder("maildir/broken1");
ok(!$test->valid());

$folders = Buffy::MailFolder::enumerateFolders("maildir/broken1");
is(scalar(@$folders), 0);

# Check a maildir whose root is a symlink pointing to a nonexisting directory
$test = Buffy::MailFolder::accessFolder("maildir/loop");
ok(!$test->valid());

$folders = Buffy::MailFolder::enumerateFolders("maildir/loop");
is(scalar(@$folders), 0);

# Check a maildir which has a submaildir that is a symlink pointing up
$test = Buffy::MailFolder::accessFolder("maildir/loop1");
ok($test->valid());

$folders = Buffy::MailFolder::enumerateFolders("maildir/loop1");
is(scalar(@$folders), 1);

# Check maildir enumeration
$folders = Buffy::MailFolder::enumerateFolders("maildir");
is(scalar(@$folders), 4);

#
# Test Mailbox
#

# Check an empty mailbox
$test = Buffy::MailFolder::accessFolder("mbox/empty.mbox");
ok($test->valid);
is($test->name(), "empty.mbox");
is($test->path(), "mbox/empty.mbox");
is($test->type(), "Mailbox");

is($test->getMsgTotal(), -1);
is($test->getMsgUnread(), -1);
is($test->getMsgNew(), -1);
is($test->getMsgFlagged(), -1);
ok($test->changed());

$test->updateStatistics();
is($test->getMsgTotal(), 0);
is($test->getMsgUnread(), 0);
is($test->getMsgNew(), 0);
is($test->getMsgFlagged(), 0);
ok(!$test->changed());

$folders = Buffy::MailFolder::enumerateFolders("mbox/empty.mbox");
is(scalar(@$folders), 1);

# Check a non empty mailbox
$test = Buffy::MailFolder::accessFolder("mbox/test.mbox");
ok($test->valid());
is($test->name(), "test.mbox");
is($test->path(), "mbox/test.mbox");
is($test->type(), "Mailbox");

is($test->getMsgTotal(), -1);
is($test->getMsgUnread(), -1);
is($test->getMsgNew(), -1);
is($test->getMsgFlagged(), -1);
ok($test->changed());

$test->updateStatistics();
is($test->getMsgTotal, 3);
is($test->getMsgUnread, 0);
is($test->getMsgNew, 0);
is($test->getMsgFlagged, 1);
ok(!$test->changed());

$folders = Buffy::MailFolder::enumerateFolders("mbox/test.mbox");
is(scalar(@$folders), 1);

# Check a mailbox whose root is a broken symlink
$test = Buffy::MailFolder::accessFolder("mbox/broken.mbox");
ok(!$test->valid());

$folders = Buffy::MailFolder::enumerateFolders("mbox/broken.mbox");
is(scalar(@$folders), 0);

# Check enumeration of a directory with mailboxes
$folders = Buffy::MailFolder::enumerateFolders("mbox");
is(scalar(@$folders), 2);
