#ifndef OSL_PTYPE_LIST_H
#define OSL_PTYPE_LIST_H

#include "osl/ptype.h"
#include "osl/ptypeTraits.h"
#include <iosfwd>
#include <boost/static_assert.hpp>
namespace osl
{
  /** Ptype の template による list */
  namespace ptl{

    class NullPtype{
    public:
      static void show(std::ostream& os);
    };

    template<Ptype T,class U>
    struct PtypeList;

    template<class T>
    struct IsPtypeList{
      static const bool isPtypeList=false;
    };
  
    template<>
    struct IsPtypeList<NullPtype>{
      static const bool isPtypeList=true;
    };

    template<Ptype T,class U>
    struct IsPtypeList<PtypeList<T,U> >{
      static const bool isPtypeList=true;
    };


    template<Ptype T,class U>
    // static assertでUが
    struct PtypeList{
      BOOST_STATIC_ASSERT(IsPtypeList<U>::isPtypeList);
      static const Ptype value=T;
      typedef U Tail;
      static void show(std::ostream& os);
    };


#define PTYPELIST_1(T1) PtypeList<T1,NullPtype>
#define PTYPELIST_2(T1,T2) PtypeList<T1,PTYPELIST_1(T2) >
#define PTYPELIST_3(T1,T2,T3) PtypeList<T1,PTYPELIST_2(T2,T3) >
#define PTYPELIST_4(T1,T2,T3,T4) PtypeList<T1,PTYPELIST_3(T2,T3,T4) >
#define PTYPELIST_5(T1,T2,T3,T4,T5) PtypeList<T1,PTYPELIST_4(T2,T3,T4,T5) >
#define PTYPELIST_6(T1,T2,T3,T4,T5,T6)\
  PtypeList<T1,PTYPELIST_5(T2,T3,T4,T5,T6) >
#define PTYPELIST_7(T1,T2,T3,T4,T5,T6,T7)\
 PtypeList<T1,PTYPELIST_6(T2,T3,T4,T5,T6,T7) >
#define PTYPELIST_8(T1,T2,T3,T4,T5,T6,T7,T8)\
 PtypeList<T1,PTYPELIST_7(T2,T3,T4,T5,T6,T7,T8) >
#define PTYPELIST_9(T1,T2,T3,T4,T5,T6,T7,T8,T9)\
 PtypeList<T1,PTYPELIST_8(T2,T3,T4,T5,T6,T7,T8,T9) >
#define PTYPELIST_10(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)\
 PtypeList<T1,PTYPELIST_9(T2,T3,T4,T5,T6,T7,T8,T9,T10) >
#define PTYPELIST_11(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11)\
 PtypeList<T1,PTYPELIST_10(T2,T3,T4,T5,T6,T7,T8,T9,T10,T11) >
#define PTYPELIST_12(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12)\
 PtypeList<T1,PTYPELIST_11(T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12) >
#define PTYPELIST_13(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13)\
 PtypeList<T1,PTYPELIST_12(T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13) >
#define PTYPELIST_14(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14)\
 PtypeList<T1,PTYPELIST_13(T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14) >
#define PTYPELIST_15(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15)\
 PtypeList<T1,PTYPELIST_14(T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15) >
#define PTYPELIST_16(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16)\
 PtypeList<T1,PTYPELIST_15(T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16) >

    typedef PTYPELIST_16(PTYPE_EMPTY,PTYPE_EDGE,PPAWN,PLANCE,PKNIGHT,PSILVER,PBISHOP,PROOK,GOLD,KING,PAWN,LANCE,KNIGHT,SILVER,BISHOP,ROOK) PtypeListAll;


    /**
     * 
     */
    template<class PTList,Ptype T>
    struct IsMember;

    template<Ptype T>
    struct IsMember<NullPtype,T>{
      static const bool value=false;
    };
    template<Ptype T> 
    const bool IsMember<NullPtype,T>::value;

    template<Ptype T1,Ptype T2,class U>
    struct IsMember<PtypeList<T2,U>,T1 >{
      static const bool value=IsMember<U,T1>::value;
    };
    template<Ptype T1,Ptype T2,class U>
    const bool IsMember<PtypeList<T2,U>,T1 >::value;

    template<Ptype T,class U>
    struct IsMember<PtypeList<T,U>,T >{
      static const bool value=true;
    };
    template<Ptype T,class U>
    const bool IsMember<PtypeList<T,U>,T >::value;

    /**
     * 条件を満たすPtypeだけを残すfilter
     */
    template<class PTList,class CheckPtype> struct Filter;

    template<class CheckPtype> 
    struct Filter<NullPtype,CheckPtype>{
      typedef NullPtype Result;
    };

    template<Ptype T,class U,bool condition,class  CheckPtype>  struct FilterDispatch;

    template<Ptype T,class U,class CheckPtype>
    struct FilterDispatch<T,U,true,CheckPtype>{
      typedef PtypeList<T,typename Filter<U,CheckPtype>::Result> Result;
    };
  
    template<Ptype T,class U,class CheckPtype>
    struct FilterDispatch<T,U,false,CheckPtype>{
      typedef typename Filter<U,CheckPtype>::Result Result;
    };

    template<Ptype T,class U,class CheckPtype >
    struct Filter< PtypeList<T,U>,CheckPtype>{
      typedef typename FilterDispatch<T,U,CheckPtype::template PtypeToBool<T>::value,CheckPtype>::Result Result;
    };
  
    /**
     * basicなものだけ 
     */
    struct CheckIsBasic{
      template<Ptype T>
      struct PtypeToBool{
	static const bool value=PtypeTraits<T>::isBasic;
      };
    };
  
    typedef Filter<PtypeListAll,CheckIsBasic>::Result PtypeListIsBasic;
    /**
     * moveMaskを持つ
     */
    template<unsigned int moveMask>
    struct CheckHasMoveMask{
      template<Ptype T>
      struct PtypeToBool{
	static const bool value=(PtypeTraits<T>::moveMask & moveMask)!=0;
      };
    };
  }

};

#endif /* OSL_PTYPE_LIST_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:

