# Authors: Frank Stappers
# Copyright: see the accompanying file COPYING or copy at
# https://svn.win.tue.nl/trac/MCRL2/browser/trunk/COPYING
#
# Distributed under the Boost Software License, Version 1.0.
# (See accompanying file LICENSE_1_0.txt or copy at
# http://www.boost.org/LICENSE_1_0.txt)

if (NOT APPLE)
  return()
endif()

##---------------------------------------------------
## Set Compiler options 
##---------------------------------------------------

set(CMAKE_EXE_LINKER_FLAGS "-framework Carbon ${CMAKE_EXE_LINKER_FLAGS}")
set(CMAKE_SHARED_LINKER_FLAGS "-framework Carbon -single_module ${CMAKE_SHARED_LINKER_FLAGS}")
set(CMAKE_MODULE_LINKER_FLAGS "-framework Carbon ${CMAKE_SHARED_LINKER_FLAGS}")

##---------------------------------------------------
## Set Shared Build  
##---------------------------------------------------
option(BUILD_SHARED_LIBS "Enable/disable creation of shared libraries" OFF) 

##---------------------------------------------------
## Toggle profile build
##---------------------------------------------------

option(MCRL2_ENABLE_PROFILING "Enable/disable profiling support" OFF)
message(STATUS "MCRL2_ENABLE_PROFILING: ${MCRL2_ENABLE_PROFILING}")
if( MCRL2_ENABLE_PROFILING )
  add_definitions( -pg )
  set(CMAKE_EXE_LINKER_FLAGS "-pg ${CMAKE_EXE_LINKER_FLAGS}")
  set(CMAKE_SHARED_LINKER_FLAGS "-pg ${CMAKE_SHARED_LINKER_FLAGS}")
  set(CMAKE_MODULE_LINKER_FLAGS "-pg ${CMAKE_SHARED_LINKER_FLAGS}")
endif(MCRL2_ENABLE_PROFILING)

##---------------------------------------------------
## Toggle Man page generation 
##---------------------------------------------------
## Setup man page generation.
## Man pages are generated by individual tools.
##---------------------------------------------------

option(MCRL2_MAN_PAGES "Enable/disable creation of UNIX man pages" ON)
message(STATUS "MCRL2_MAN_PAGES: ${MCRL2_MAN_PAGES}")

##---------------------------------------------------
## Toggle Single Bundle Build 
##---------------------------------------------------
option(MCRL2_OSX_PACKAGE "Enable/disable settings for an OS-X distributable binary package" OFF)

##---------------------------------------------------
## A single bundle build requires static linking, since
## the bundle is re-locatable   
##---------------------------------------------------
if( MCRL2_OSX_PACKAGE AND BUILD_SHARED_LIBS )
  message( FATAL_ERROR "BUILD_SHARED_LIBS requires to be FALSE when compiling with MCRL2_OSX_PACKAGE set to TRUE" )
endif( MCRL2_OSX_PACKAGE AND BUILD_SHARED_LIBS )

##---------------------------------------------------
## Set locations for binary package.
##---------------------------------------------------
if(MCRL2_OSX_PACKAGE)
  set(MCRL2_BIN_DIR "Applications")
  set(MCRL2_LIB_DIR "Library")
  set(MCRL2_SHARE_DIR "Documents")
  set(MCRL2_MAN_DIR "man/man1")
  set(MCRL2_EXAMPLES_DIR "Examples")
  set(MCRL2_INCLUDE_DIR "Headers/include")
endif(MCRL2_OSX_PACKAGE)
