<?php

/** Lower Sorbian (Dolnoserbski)
 *
 * @ingroup Language
 */
class LanguageDsb extends Language {

	/**
	 * Convert from the nominative form of a noun to some other case
	 * Invoked with {{grammar:case|word}}
	 *
	 * @param $word string
	 * @param $case string
	 * @return string
	 */
	function convertGrammar( $word, $case ) {
		global $wgGrammarForms;
		if ( isset( $wgGrammarForms['dsb'][$case][$word] ) ) {
			return $wgGrammarForms['dsb'][$case][$word];
		}

		switch ( $case ) {
			case 'instrumental': # instrumental
				$word = 'z ' . $word;
			case 'lokatiw': # lokatiw
				$word = 'wo ' . $word;
				break;
			}

		return $word; # this will return the original value for 'nominatiw' (nominativ) and all undefined case values
	}

	/**
	 * @param $count int
	 * @param $forms array
	 * @return string
	 */
	function convertPlural( $count, $forms ) {
		if ( !count( $forms ) ) { return ''; }
		$forms = $this->preConvertPlural( $forms, 4 );

		switch ( abs( $count ) % 100 ) {
			case 1:  return $forms[0]; // singular
			case 2:  return $forms[1]; // dual
			case 3:
			case 4:  return $forms[2]; // plural
			default: return $forms[3]; // pluralgen
		}
	}
}
