/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/


#ifndef MvQListHelp_H
#define MvQListHelp_H

#include "MvQRequestPanelHelp.h"
#include "Parameter.h"

#include <QListWidget>
#include <QMap>
#include <QString>

class  RequestPanel;

class MvQParamList : public QListWidget, public ParameterScanner
{
public:  
	MvQParamList(const Parameter& param,QWidget *parent=0);
	
protected:
        void adjustHeight();
    	void next(const Parameter&, const char* first,const char* second);
	
	const Parameter& param_;
};  

class MvQListHelp : public MvQRequestPanelHelp
{
Q_OBJECT  

public:
	MvQListHelp(RequestPanel& owner,const Parameter& param);
	~MvQListHelp() {};
	
	void start() {};
	bool dialog() {return false;}	
	QWidget* widget() {return paramList_;}

public slots:
	void slotListChanged(QListWidgetItem*);
  
protected:
	virtual void refresh(const vector<string>&);
  	virtual long flags() {return 9;}
	virtual void set(Request&) {}
	
	QListWidget* paramList_;
	bool multiple_;
};	

#endif
