/***************************** LICENSE START ***********************************

 Copyright 2013 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END ************/

#include "IconGroupTools.h"
#include "ConfigLoader.h"
#include "Request.h"

static vector<IconGroupTools*> tools;

IconGroupTools::IconGroupTools(request* r) :
    request_(r)
{
}

IconGroupTools::~IconGroupTools()
{
}

string IconGroupTools::name()
{
    return string(get_value(request_, "name", 0));
}

bool IconGroupTools::can(const string& name)
{
    for (vector<IconGroupTools*>::iterator it = tools.begin(); it != tools.end(); it++)
        if ((*it)->name() == name)
            return true;
    return false;
}

void IconGroupTools::run(const string& name, const vector<IconObject*>& items)
{
    for (vector<IconGroupTools*>::iterator it = tools.begin(); it != tools.end(); it++)
        if ((*it)->name() == name)
            (*it)->run(items);
}

void IconGroupTools::run(const vector<IconObject*>& items)
{
    MvRequest r(get_value(request_, "action", 0));

    if (const char* par = get_value(request_, "param", 0)) {
        r.setValue("PARAM", par);
    }

    for (vector<IconObject*>::const_iterator it = items.begin(); it != items.end(); it++) {
        r.addValue("ITEMS", (*it)->fullName().c_str());
    }

    // indicate that the ui manager should wait for the ui app to finish!!
    r("_WAIT_APP") = "1";

    MvApplication::callService(get_value(request_, "service", 0), r, 0);
}


void IconGroupTools::load(request* r)
{
    tools.push_back(new IconGroupTools(r));
}


static SimpleLoader<IconGroupTools> loadClasses("desktop_icon_group_tool", 1);
