message(STATUS "UNIX toolchain")

set(CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES /usr/include)
set(CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES /usr/include)

find_package(
    Qt6 REQUIRED
    COMPONENTS Widgets
               Xml
               Svg
               SvgWidgets
               PrintSupport
               Network
               Qml
               Sql
               Concurrent
               Core5Compat
               GLOBAL
)


# Find the libIsoSpec library
find_package(IsoSpec++ GLOBAL REQUIRED)

find_package(PwizLite REQUIRED)

find_package(
    Boost
    COMPONENTS chrono
               container
               filesystem
               iostreams
               thread
    REQUIRED
)

if(SQLite3_FOUND)
else(SQLite3_FOUND)
    set(SQLite3_DIR ${CMAKE_MODULE_PATH})
    find_package(SQLite3 REQUIRED)
endif(SQLite3_FOUND)


find_package(QCustomPlotQt6 REQUIRED)
message(STATUS "Setting definition -DQCUSTOMPLOT_USE_LIBRARY.")

find_package(ZLIB REQUIRED)

find_package(Zstd REQUIRED)

find_package(liblzf REQUIRED)

find_package(OdsStream COMPONENTS Core)

find_package(QuaZip-Qt6 REQUIRED)


if(PAPPSO_LOCAL_INST)
    message(STATUS "Selecting the /usr/local/lib pappso libs.")
    include(${CMAKE_TOOLCHAINS_PATH}/unix-toolchain-local-inst-pappso.cmake)
elseif(PAPPSO_LOCAL_DEV)
    message(STATUS "Selecting the local development pappso lib.")
    include(${CMAKE_TOOLCHAINS_PATH}/unix-toolchain-local-dev-pappso.cmake)
else()
    find_package(
        PappsoMSpp
        COMPONENTS Core Gui GLOBAL
        REQUIRED
    )
endif()

if(XPERTMASS_LOCAL_INST)
    message(STATUS "Selecting the /usr/local/lib xpertmass libs.")
    include(${CMAKE_TOOLCHAINS_PATH}/unix-toolchain-local-inst-xpertmass.cmake)
elseif(XPERTMASS_LOCAL_DEV)
    message(STATUS "Selecting the local development xpertmass lib.")
    include(${CMAKE_TOOLCHAINS_PATH}/unix-toolchain-local-dev-xpertmass.cmake)
else()
    find_package(
        XpertMass
        COMPONENTS Core Gui GLOBAL
        REQUIRED
    )
endif()

get_target_property(CORE_LIB_PATH XpertMass::Core LOCATION)
message(STATUS "XpertMass::Core path: ${CORE_LIB_PATH}")
get_target_property(GUI_LIB_PATH XpertMass::Gui LOCATION)
message(STATUS "XpertMass::Gui path: ${GUI_LIB_PATH}")


#OPENMP
message(STATUS "${BoldYellow}OpenMP support is compulsory.${ColourReset}")
#message(STATUS "CMAKE_MODULE_PATH: ${CMAKE_MODULE_PATH}")
#set(OpenMP_DIR ${CMAKE_MODULE_PATH})

find_package(OpenMP REQUIRED)

#We know this one is empty:
#message(STATUS "OpenMP found with include dirs: ${OpenMP_CXX_INCLUDE_DIRS}")

#Which is why we will reconstruct it for gcc
#on the basis of the path to the libgomp.so library.The include
#directory is nothing more than the path to that library with '/include'
#added to it.This is what is done below.
message(STATUS "OpenMP found with libraries: ${OpenMP_CXX_LIBRARIES}")

# On mingw64 with ucrt64 environment, the include file is
# /c/msys64/ucrt64/lib/gcc/x86_64-w64-mingw32/13.2.0/include/omp.h

if(OpenMP_CXX_INCLUDE_DIRS STREQUAL "")

    message(STATUS "OpenMP include directories could not be found.
  Crafting them manually starting from the library directories."
    )

    if(CMAKE_COMPILER_IS_GNUCXX)

        message(STATUS "The compiler is CMAKE_COMPILER_IS_GNUCXX")

        #We now need to extract the libgomp.so library path, and craft the
        #include dir path which is replacing libgomp.so with include.
        set(OpenMP_CXX_INCLUDE_DIRS ${OpenMP_CXX_LIBRARIES})
        list(
            FILTER
            OpenMP_CXX_INCLUDE_DIRS
            INCLUDE
            REGEX
            ".*libgomp.*"
        )
        #message(STATUS "Started crafting OpenMP include dirs: ${OpenMP_CXX_INCLUDE_DIRS}")
        list(LENGTH OpenMP_CXX_INCLUDE_DIRS INCLUDE_DIRS_LIST_LENGTH)
        #message(STATUS "Remaining items in OpenMP_CXX_INCLUDE_DIRS: ${INCLUDE_DIRS_LIST_LENGTH}")
        list(GET OpenMP_CXX_INCLUDE_DIRS 0 OpenMP_CXX_INCLUDE_DIR)
        #message(STATUS "Started crafting OpenMP include dir: ${OpenMP_CXX_INCLUDE_DIR}")
        string(REGEX REPLACE "libgomp.so.*" "include" OpenMP_CXX_INCLUDE_SINGLE_DIR ${OpenMP_CXX_INCLUDE_DIR})
        message(STATUS "OpenMP single include dir: ${OpenMP_CXX_INCLUDE_SINGLE_DIR}")

        if(EXISTS "${OpenMP_CXX_INCLUDE_SINGLE_DIR}")
            set(OpenMP_CXX_INCLUDE_DIRS ${OpenMP_CXX_INCLUDE_SINGLE_DIR})
            message(STATUS "OpenMP found with include dirs: ${OpenMP_CXX_INCLUDE_DIRS}")
        else()
            set(OpenMP_CXX_INCLUDE_DIRS "")
            message(STATUS "OpenMP found but not the include directories.")
        endif()

    else() # Compiler is not CMAKE_COMPILER_IS_GNUCXX

        # Check if the compiler is clang++

        #set(DEBUG_COMPILER "/usr/bin/clang")
        #string(REGEX MATCH ".*clang\\+\\+.*" CMAKE_CXX_COMPILER_IS_CLANG ${DEBUG_COMPILER})

        string(REGEX MATCH ".*clang\\+\\+.*" CMAKE_CXX_COMPILER_IS_CLANG ${CMAKE_CXX_COMPILER})
        #string(FIND ${CMAKE_CXX_COMPILER} "clang++" CMAKE_CXX_COMPILER_IS_CLANG)

        if(CMAKE_CXX_COMPILER_IS_CLANG STREQUAL "")

            message(STATUS "Failed to identify compiler different than g++ and clang++")

        else()

            message(STATUS "The compiler has been identified as clang++: ${CMAKE_CXX_COMPILER}")

            execute_process(
                COMMAND bash -c "clang --print-resource-dir"
                OUTPUT_STRIP_TRAILING_WHITESPACE
                OUTPUT_VARIABLE CLANG_RESOURCE_DIR
            )

            if(${CLANG_RESOURCE_DIR} STREQUAL "")

                message(STATUS "Failed to determine the Clang resource dir")

            else()

                #message(STATUS "Clang resource dir: \"${CLANG_RESOURCE_DIR}\"")
                set(CLANG_RESOURCE_DIR "${CLANG_RESOURCE_DIR}/include")
                #message(STATUS "Clang resource dir: ${CLANG_RESOURCE_DIR}")

                if(EXISTS "${CLANG_RESOURCE_DIR}")
                    set(OpenMP_CXX_INCLUDE_DIRS ${CLANG_RESOURCE_DIR})
                    message(STATUS "OpenMP found with include dirs: ${OpenMP_CXX_INCLUDE_DIRS}")
                else()
                    set(OpenMP_CXX_INCLUDE_DIRS "")
                    message(STATUS "OpenMP found but not the include directories.")
                endif()

            endif()

        endif()

    endif()

endif()

################# INSTALL directories #################
################# INSTALL directories #################
################# INSTALL directories #################

#### These directories do not include the CMAKE_INSTALL_PREFIX path.
#### In the install actions of this CMake-based configuration, only use
#### PROJECT_INSTALL_<VARIABLE>

set(PROJECT_INSTALL_PREFIX ${CMAKE_INSTALL_PREFIX})
message("The project install prefix: ${PROJECT_INSTALL_PREFIX}")

### The directory where the binary is to be installed
set(PROJECT_INSTALL_BIN_DIR ${CMAKE_INSTALL_BINDIR})
message(STATUS "The project install bin dir: ${PROJECT_INSTALL_BIN_DIR}")

message(STATUS "The install library ${CMAKE_INSTALL_LIBDIR} default: ${CMAKE_INSTALL_LIBDIR}")

# I thought it was necessary to define the install lib dir with triplet, but
# CMake does its choice alone.

# get_deb_triplet_string(DEB_TRIPLET_STRING)
#
# if(NOT "${CMAKE_LIBRARY_ARCHITECTURE}" STREQUAL "${DEB_TRIPLET_STRING}")
#     message(FATAL_ERROR "Odd situation where CMAKE_LIBRARY_ARCHITECTURE is not equal to DEB_TRIPLET_STRING")
# endif()
#
# if(DEB_TRIPLET_STRING)
#     set(CMAKE_INSTALL_TRIPLET_LIBDIR ${CMAKE_INSTALL_LIBDIR}/${DEB_TRIPLET_STRING})
#     set(CMAKE_INSTALL_FULL_TRIPLET_LIBDIR ${CMAKE_INSTALL_FULL_LIBDIR}/${DEB_TRIPLET_STRING})
# endif()
#
# message(STATUS "The install library is configured: ${CMAKE_INSTALL_LIBDIR}")
# message(STATUS "The full install library is configured: ${CMAKE_INSTALL_FULL_LIBDIR}")
#
# message(STATUS "The install triplet library is configured: ${CMAKE_INSTALL_TRIPLET_LIBDIR}")
# message(STATUS "The full install triplet library is configured: ${CMAKE_INSTALL_FULL_TRIPLET_LIBDIR}")

set(PROJECT_INSTALL_LIB_DIR ${CMAKE_INSTALL_LIBDIR})
message(STATUS "The project install lib dir: ${PROJECT_INSTALL_LIB_DIR}")

set(PROJECT_INSTALL_LIB_QML_DIR ${PROJECT_INSTALL_LIB_DIR}/qml)
message(STATUS "The project install lib qml dir: ${PROJECT_INSTALL_LIB_QML_DIR}")

# This one is the share directory on UNIX
set(PROJECT_INSTALL_DATA_DIR ${CMAKE_INSTALL_DATADIR}/${LOWCASE_PROJECT_NAME})
message(STATUS "The project install data dir: ${PROJECT_INSTALL_DATA_DIR}")

set(PROJECT_INSTALL_DOC_DIR ${CMAKE_INSTALL_DATADIR}/doc/${LOWCASE_PROJECT_NAME})
message(STATUS "The project install doc dir: ${PROJECT_INSTALL_DOC_DIR}")

# The appstream, desktop and icon files
install(
    FILES org.msxpertsuite.${PROJECT_NAME}.desktop
    DESTINATION ${CMAKE_INSTALL_DATADIR}/applications
)

install(
    FILES org.msxpertsuite.${PROJECT_NAME}.appdata.xml
    DESTINATION ${CMAKE_INSTALL_DATADIR}/metainfo
)

install(
    FILES images/icons/16x16/${PROJECT_NAME}.png
    DESTINATION ${CMAKE_INSTALL_DATADIR}/icons/hicolor/16x16/apps
)

install(
    FILES images/icons/32x32/${PROJECT_NAME}.png
    DESTINATION ${CMAKE_INSTALL_DATADIR}/icons/hicolor/32x32/apps
)

install(
    FILES images/icons/48x48/${PROJECT_NAME}.png
    DESTINATION ${CMAKE_INSTALL_DATADIR}/icons/hicolor/48x48/apps
)

install(
    FILES images/icons/64x64/${PROJECT_NAME}.png
    DESTINATION ${CMAKE_INSTALL_DATADIR}/icons/hicolor/64x64/apps
)

# Prepare the AppImage recipe file to be used elsewhere,
# for deploying mineXpert3 on non-Debian- or non-Ubuntu platforms.

configure_file(
    ${CMAKE_SOURCE_DIR}/CMakeStuff/${CMAKE_PROJECT_NAME}-appimage-recipe.yml.in
    ${CMAKE_SOURCE_DIR}/appimage/${CMAKE_PROJECT_NAME}-appimage-recipe.yml @ONLY
)

## Platform-dependent compiler flags:
include(CheckCXXCompilerFlag)

if(WITH_FPIC)
    add_definitions(-fPIC)
endif()
