set(BERKELIUM_ROOT "" CACHE PATH "Path to Berklium sources")
SET(BERKELIUM_FOUND FALSE)
IF(EXISTS ${BERKELIUM_ROOT}/include AND EXISTS ${BERKELIUM_ROOT}/lib)
  SET(BERKELIUM_INCLUDE_DIRS ${BERKELIUM_ROOT}/include)
  SET(BERKELIUM_LIBRARY_DIRS ${BERKELIUM_ROOT}/lib)
ELSE()
IF(WIN32)
IF(EXISTS ${BERKELIUM_ROOT}/win32/berkelium.lib AND EXISTS ${BERKELIUM_ROOT}/win32/berkelium.exe)
  SET(BERKELIUM_INCLUDE_DIRS ${BERKELIUM_ROOT}/include)
  SET(BERKELIUM_LIBRARY_DIRS ${BERKELIUM_ROOT}/win32)
ENDIF()
ENDIF()
ENDIF()
IF(BERKELIUM_INCLUDE_DIRS AND BERKELIUM_LIBRARY_DIRS)
  IF(WIN32)  # Windows
    FIND_LIBRARY(BERKELIUM_DEBUG_LIBRARY   NAMES berkelium_d
                 PATH_SUFFIXES "" Debug   PATHS ${BERKELIUM_LIBRARY_DIRS} NO_DEFAULT_PATH)
    FIND_LIBRARY(BERKELIUM_RELEASE_LIBRARY NAMES berkelium
                 PATH_SUFFIXES "" Release PATHS ${BERKELIUM_LIBRARY_DIRS} NO_DEFAULT_PATH)
    SET(BERKELIUM_LIBRARIES)
    IF(BERKELIUM_DEBUG_LIBRARY AND BERKELIUM_RELEASE_LIBRARY)
      SET(BERKELIUM_LIBRARIES debug ${BERKELIUM_DEBUG_LIBRARY} optimized ${BERKELIUM_RELEASE_LIBRARY})
    ELSEIF(BERKELIUM_DEBUG_LIBRARY)
      SET(BERKELIUM_LIBRARIES ${BERKELIUM_DEBUG_LIBRARY})
    ELSEIF(BERKELIUM_RELEASE_LIBRARY)
      SET(BERKELIUM_LIBRARIES ${BERKELIUM_RELEASE_LIBRARY})
    ENDIF(BERKELIUM_DEBUG_LIBRARY AND BERKELIUM_RELEASE_LIBRARY)
  ELSE(WIN32)  # Linux etc
    FIND_LIBRARY(BERKELIUM_LIBRARIES NAMES berkelium PATHS ${BERKELIUM_LIBRARY_DIRS} NO_DEFAULT_PATH)
  ENDIF(WIN32)
  IF(BERKELIUM_LIBRARIES)
    SET(BERKELIUM_FOUND TRUE)
  ENDIF()
ENDIF()
IF(BERKELIUM_FOUND)
  MESSAGE(STATUS "Found Berkelium: headers at ${BERKELIUM_INCLUDE_DIRS}, libraries at ${BERKELIUM_LIBRARIES}")
ENDIF(BERKELIUM_FOUND)
