// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GC_MakePlane_HeaderFile
#define _GC_MakePlane_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Handle_Geom_Plane.hxx>
#include <GC_Root.hxx>
#include <Standard_Real.hxx>
class Geom_Plane;
class StdFail_NotDone;
class gp_Ax2;
class gp_Pln;
class gp_Pnt;
class gp_Dir;
class gp_Ax1;


//! This class implements the following algorithms used
//! to create a Plane from gp.
//! * Create a Plane parallel to another and passing
//! through a point.
//! * Create a Plane passing through 3 points.
//! * Create a Plane by its normal
//! A MakePlane object provides a framework for:
//! -   defining the construction of the plane,
//! -   implementing the construction algorithm, and
//! -   consulting the results. In particular, the Value
//! function returns the constructed plane.
class GC_MakePlane  : public GC_Root
{
public:

  DEFINE_STANDARD_ALLOC

  

  //! Creates a plane located in 3D space with an axis placement
  //! two axis.  The "ZDirection" of "A2" is the direction normal
  //! to the plane.  The "Location" point of "A2" is the origin of
  //! the plane. The "XDirection" and "YDirection" of "A2" define
  //! the directions of the U isoparametric and V isoparametric
  //! curves.
  Standard_EXPORT GC_MakePlane(const gp_Ax2& A2);
  

  //! Creates a plane from a non persistent plane from package gp.
  Standard_EXPORT GC_MakePlane(const gp_Pln& Pl);
  

  //! P is the "Location" point or origin of the plane.
  //! V is the direction normal to the plane.
  Standard_EXPORT GC_MakePlane(const gp_Pnt& P, const gp_Dir& V);
  

  //! Creates a plane from its cartesian equation :
  //! Ax + By + Cz + D = 0.0
  //! Status is "BadEquation" if Sqrt (A*A + B*B + C*C)
  //! <= Resolution from gp
  Standard_EXPORT GC_MakePlane(const Standard_Real A, const Standard_Real B, const Standard_Real C, const Standard_Real D);
  
  //! Make a Plane from Geom <ThePlane> parallel to another
  //! Pln <Pln> and passing through a Pnt <Point>.
  Standard_EXPORT GC_MakePlane(const gp_Pln& Pln, const gp_Pnt& Point);
  
  //! Make a Plane from Geom <ThePlane> parallel to another
  //! Pln <Pln> at the distance <Dist> which can be greater
  //! or lower than zero.
  //! In the first case the result is at the distance
  //! <Dist> to the plane <Pln> in the direction of the
  //! normal to <Pln>.
  //! Otherwize it is in the oposite direction.
  Standard_EXPORT GC_MakePlane(const gp_Pln& Pln, const Standard_Real Dist);
  
  //! Make a Plane from Geom <ThePlane> passing through 3
  //! Pnt <P1>,<P2>,<P3>.
  //! It returns false if <P1> <P2> <P3> are confused.
  Standard_EXPORT GC_MakePlane(const gp_Pnt& P1, const gp_Pnt& P2, const gp_Pnt& P3);
  
  //! Make a Plane  passing through the location of <Axis>and
  //! normal to the Direction of <Axis>.
  Standard_EXPORT GC_MakePlane(const gp_Ax1& Axis);
  
  //! Returns the constructed plane.
  //! Exceptions StdFail_NotDone if no plane is constructed.
  Standard_EXPORT  const  Handle(Geom_Plane)& Value()  const;
  
  Standard_EXPORT  const  Handle(Geom_Plane)& Operator()  const;
Standard_EXPORT operator Handle_Geom_Plane() const;




protected:





private:



  Handle(Geom_Plane) ThePlane;


};







#endif // _GC_MakePlane_HeaderFile
