/* Copyright 2011 Canonical, Ltd. This software is licensed under the GNU
 * Lesser General Public License version 3 or later (see the file COPYING).
 */

#ifndef OIF_QML_GEISSINGLETON_H_
#define OIF_QML_GEISSINGLETON_H_

#include <QHash>
#include <QMultiMap>
#include <QObject>

#include <geis/geis.h>

#include "gesture.h"
#include "gesturearea.h"

class Device;
class GestureArea;
class QSocketNotifier;

class GeisSingleton : public QObject {
  Q_OBJECT

 public:
  explicit GeisSingleton(QObject* parent = 0);
  ~GeisSingleton();

  static GeisSingleton* Instance();

  Geis geis() const { return geis_; }
  bool initialized() const { return initialized_; }
  void RegisterGestureArea(GestureArea* area);
  void UnregisterGestureArea(GestureArea* area);

 signals:
  void Initialized();

 private:
  void HandleClassEvent(GeisEvent event);
  void HandleDeviceEvent(GeisEvent event);
  void HandleGestureBeginEvent(GeisEvent event);
  void HandleGestureUpdateEvent(bool end, GeisEvent event);
  QGraphicsScene* FindSceneForTouches(WId window, const QRectF& touches);

  Geis geis_;
  bool initialized_;
  QSocketNotifier* notifier_;
  QHash< GestureArea::Primitive, GeisGestureClass > classes_;
  QHash< GeisGestureId,
         QMap< GestureArea::Primitive, GestureArea* > > active_gestures_;
  QMultiHash< WId, GestureArea* > window_map_;
  QHash< GeisInteger, Device* > device_map_;

  Q_DISABLE_COPY(GeisSingleton)

 private slots:
  void GeisEventSlot();
};

#endif  // OIF_QML_GEISSINGLETON_H_
