#!/usr/bin/env python
# -*- python -*-
#

class Symbol:

    class Table:

        def __init__(self):
            self.__table={}

        def add(self, name, entry):
            self.__table[name]=entry

        def lookup(self, name):
            return self.__table[name]

    useAlias=0
    table=Table()

    def __init__(self, mangledName):
        self.__mangledName=mangledName
        self.__demangledName=None
        self.__hidden=0
        self.__type="PROCEDURE"
        Symbol.table.add(mangledName, self)

    def str(self):
        if self.__demangledName:
            if self.__hidden:
                return '%s|@%s' % (self.__mangledName.ljust(31),
                                   self.__demangledName)
            else:
                return '%s| %s' % (self.__mangledName.ljust(31),
                                   self.__demangledName)
        else:
            return self.__mangledName

    def demangle(self, demangledName):
        self.__demangledName=demangledName
        if self.__demangledName.find('<unnamed>') != -1:
            self.hide()

    def hide(self):
        self.__hidden=1

    def decl(self):
        return self.__demangledName

    def symbolVectorEntry(self):
        if self.__hidden:
            entry=None
        elif self.__mangledName.isupper() or not Symbol.useAlias:
            entry="SYMBOL_VECTOR=(%s=%s)" % (self.__mangledName, self.__type)
        else:
            entry="SYMBOL_VECTOR=(%s=%s,%s/%s=%s)" % (self.__mangledName,
                                                    self.__type,
                                                    self.__mangledName.upper(),
                                                    self.__mangledName,
                                                    self.__type)
        return entry

    def reclassify(self):
##        if self.__type=="PROCEDURE":
        self.__type="DATA"
##        elif self.__type=="DATA":
##            self.__type="PROCEDURE"
        print '''%s reclassified as %s''' % (self.__mangledName,
                                             self.__type)

class Module:

    def __init__(self, name):
        self.__name=name
        self.__entries=[]

    def append(self, entry):
        self.__entries.append(entry)

    def prn(self):
        print 80*'-'
        print self.__name
        print 80*'-'
        print
        for entry in self.__entries:
            print entry.str()
        print 80*'-'
        print

    def numEntries(self):
        return len(self.__entries)

    def entry(self, inx):
        return self.__entries[inx]

    def name(self):
        return self.__name

    def entries(self):
        return self.__entries

    def hideInitializers(self):

        '''\
Remove the initialization entry points that CXX creates.

For some really odd reason, the CXX compiler sometimes creates a
function called __init_MODULE_CC_... and a pointer to said function
called _p_init_MODULE_CC_.... where MODULE_CC is taken from the name
of the file and "..." is a random looking sequence of characters.

This function will never be called from outside the shareable
image. Therefore we hide these entry points.
'''

        import re
        moduleId=self.__name.replace('-','_').replace('^.','_')
        init=re.compile('''void __init_%s_[a-zA-Z0-9_]+\(\)''' % moduleId)
        pinit=re.compile('''void \(\*const _p__init_%s_[a-zA-Z0-9_]+\)\(\)'''
                        % moduleId)
        for entry in self.__entries:

            # Note that match is wrongheaded perlishness that works in
            # this case since we *are* at the start of the string.

            if init.match(entry.decl()):
                entry.hide()
            elif pinit.match(entry.decl()):
                entry.hide()

    def symbolVectorEntries(self, out):
        out.write("""!\n! %s\n!\n""" % self.__name)
        for entry in self.__entries:
            vectorEntry=entry.symbolVectorEntry()
            if vectorEntry:
                out.write(vectorEntry+'\n')

import os

##libdir='''rjr_share_disk:[RJRDPC.omniORB.omni.lib.openvms_alpha_7_3]'''
libdir='''omnilib:'''
libname='''omniorb4'''
lib=libdir+libname
namesfile=lib+'.dat'
repositoryDir=libdir
imageversion='''14,3'''
optionsFilename=lib+".opt"
##optionsShortname=libname+".opt"

print '''Extracting entry point names in %s...''' % lib

namesoutput=os.popen('''lib/list/names %s''' % lib)
inHeader=1
lines=namesoutput.readlines()

print '''Parsing names in %s...''' % lib
header=[]
modules=[]
out=open(namesfile,'w')

module=None
for line in lines:
    if len(line)==1:
        inHeader=0
    if inHeader:
        header.append(line)
    else:
        tuple=line.split()
        if len(tuple):
            if len(tuple)==2 and tuple[0]=='Module':
                if module:
                    modules.append(module)
                module=Module(tuple[1])
            else:
                out.write(line)
                entry=Symbol(line[:-1])
##                print '''%s:%s''' % (module.name(), entry.str())
                module.append(entry)

if module:
    modules.append(module)

out.close()

print '''Demangling names for %s...''' % lib

cxxdemfilter=os.popen('''pipe cxxdemangler/repository=%s < %s''' %(repositoryDir,
                                                                   namesfile))
demangledNames=cxxdemfilter.readlines()

inx=0
for module in modules:
    for entry in module.entries():
        entry.demangle(demangledNames[inx][:-1])
##        print '''%s:%s''' % (module.name(), entry.str())
        inx=inx+1
    module.hideInitializers()

##for module in modules:
##    module.prn()

optionsFile=open(optionsFilename,'w')
optionsFile.write("""! Options file for %s
GSMATCH=LEQUAL,%s
CASE_SENSITIVE=YES
""" % (libname,imageversion))
for module in modules:
    module.symbolVectorEntries(optionsFile)

othersharelibs=[libdir+"omnithread_rt.exe"]
for l in othersharelibs:
    optionsFile.write("""%s/share\n""" % l)
optionsFile.close()

print """Linking %s initial pass...""" % libname

##otherlibs="omni_share.olb/include=(omnithread_rt)"
cmd="""cxxlink/repository=%s/shareable=NL:/map/full %s/opt,%s/lib""" % (
    repositoryDir,optionsFilename,libname)
print cmd
cxxlinkoutput=os.popen(cmd)
cxxlinkreport=cxxlinkoutput.readlines()

print "Reclassifying..."

import re

# %LINK-W-SYMVABNORMAL, Symbol ID_UCS_2__q1_4omni11omniCodeSet
errorMsgFormat=re.compile(
    """%LINK-W-SYMVABNORMAL, Symbol ([A-Za-z_][$A-Za-z_0-9]*)""")
for line in cxxlinkreport:
    match=errorMsgFormat.match(line)
    if match:
##        print "Reclassifying %s..." % match.group(1)
        Symbol.table.lookup(match.group(1)).reclassify()
##    else:
##        print line

Symbol.useAlias=1
optionsFile=open(optionsFilename,'w')
optionsFile.write("""! Options file for %s
GSMATCH=LEQUAL,%s
CASE_SENSITIVE=YES
""" % (libname,imageversion))
for module in modules:
    module.symbolVectorEntries(optionsFile)

othersharelibs=[libdir+"omnithread_rt.exe"]
for l in othersharelibs:
    optionsFile.write("""%s/share\n""" % l)
optionsFile.close()

print "Linking %s final pass..." % libname

shareableLib=libdir+libname+"_rt.exe"
cmd="""cxxlink/repository=%s/shareable=%s/map/full %s/opt,%s/lib""" % (
    repositoryDir,shareableLib,optionsFilename,libname)
print cmd
cxxlinkoutput=os.popen(cmd)
cxxlinkreport=cxxlinkoutput.readlines()
for line in cxxlinkreport:
    print line[:-1]
