///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <atomviz/atoms/AtomsRenderer.h>
#include "AtomVizSettingsPage.h"
#include <atomviz/benchmark/AtomVizBenchmarkUtility.h>

namespace AtomViz {

IMPLEMENT_PLUGIN_CLASS(AtomVizSettingsPage, ApplicationSettingsPage)

/******************************************************************************
* Creates the widget that contains the plugin specific setting controls.
******************************************************************************/
void AtomVizSettingsPage::insertSettingsDialogPage(SettingsDialog* settingsDialog, QTabWidget* tabWidget)
{
	this->settingsDialog = settingsDialog;
	QWidget* page = new QWidget();
	tabWidget->addTab(page, tr("AtomViz"));

	QGridLayout* layout1 = new QGridLayout(page);

	QGroupBox* renderingMethodGroupBox = new QGroupBox(tr("Rendering method"), page);
	layout1->addWidget(renderingMethodGroupBox, 0, 0);
	QVBoxLayout* layout2 = new QVBoxLayout(renderingMethodGroupBox);

	QLabel* label1 = new QLabel(tr("<html><p>These settings control the rendering method used to display atoms in the viewports. "
			"Note that your graphics card may not support all available options. The rendering engine "
			"will automatically fall back to the next supported method that is compatible with your graphics card. "
			"With the <a href=\"none\">OpenGL test utility</a>, you can check which rendering methods are supported by your system.</p></html>"));
	label1->setWordWrap(true);
	label1->setTextFormat(Qt::RichText);
	label1->setTextInteractionFlags(Qt::TextBrowserInteraction);
	connect(label1, SIGNAL(linkActivated(const QString &)), this, SLOT(openOpenGLTestUtility()));
	layout2->addWidget(label1);

	QHBoxLayout* layout2a = new QHBoxLayout();
	defaultRenderingMethodBox = new QComboBox();
	layout2a->addWidget(new QLabel(tr("Default rendering method:")));
	layout2a->addWidget(defaultRenderingMethodBox);
	layout2a->addStretch(1);
	layout2->addLayout(layout2a);

	QLabel* label2 = new QLabel(tr("<html><p>Controls the atom rendering method used for high-quality display of atoms. High-quality mode is activated during "
			"still image generation or when it is explicitely enabled by the user in the atoms object rollout.</p></html>"));
	label2->setWordWrap(true);
	layout2->addWidget(label2);

	layout2a = new QHBoxLayout();
	defaultHQRenderingMethodBox = new QComboBox();
	layout2a->addWidget(new QLabel(tr("High-quality rendering method:")));
	layout2a->addWidget(defaultHQRenderingMethodBox);
	layout2a->addStretch(1);
	layout2->addLayout(layout2a);

	defaultRenderingMethodBox->addItem(tr("1. Quad geometry with billboard texture maps"), AtomsRenderer::QUAD_GEOMETRY_IMPOSTERS);
	defaultRenderingMethodBox->addItem(tr("2. Scaled point sprites with billboard texture maps"), AtomsRenderer::POINT_SPRITE_IMPOSTERS);
	defaultRenderingMethodBox->addItem(tr("3. Scaled point sprites with 2D hardware shader (default)"), AtomsRenderer::SHADED_POINT_SPRITE_IMPOSTERS);
	defaultRenderingMethodBox->addItem(tr("4. Cube geometry with raytrace hardware shader"), AtomsRenderer::SHADED_RAYTRACED_SPHERES);

	defaultHQRenderingMethodBox->addItem(tr("1. Quad geometry with billboard texture maps"), AtomsRenderer::QUAD_GEOMETRY_IMPOSTERS);
	defaultHQRenderingMethodBox->addItem(tr("2. Scaled point sprites with billboard texture maps"), AtomsRenderer::POINT_SPRITE_IMPOSTERS);
	defaultHQRenderingMethodBox->addItem(tr("3. Scaled point sprites with 2D hardware shader"), AtomsRenderer::SHADED_POINT_SPRITE_IMPOSTERS);
	defaultHQRenderingMethodBox->addItem(tr("4. Cube geometry with raytrace hardware shader (default)"), AtomsRenderer::SHADED_RAYTRACED_SPHERES);

	defaultRenderingMethodBox->setCurrentIndex(defaultRenderingMethodBox->findData(AtomsRenderer::defaultRenderingMethod()));
	defaultHQRenderingMethodBox->setCurrentIndex(defaultHQRenderingMethodBox->findData(AtomsRenderer::defaultHQRenderingMethod()));

	QLabel* label3 = new QLabel(tr("<html><p>Note: You should restart Ovito for the changes to take effect.</p></html>"));
	label3->setWordWrap(true);
	layout2->addWidget(label3);
}

/******************************************************************************
* Opens the OpenGL test utility.
******************************************************************************/
void AtomVizSettingsPage::openOpenGLTestUtility()
{
	settingsDialog->reject();
	AtomVizOpenGLBenchmarkWindow::showBenchmarkWindow();
}

/******************************************************************************
* Lets the settings page to save all
******************************************************************************/
void AtomVizSettingsPage::saveValues(SettingsDialog* settingsDialog)
{
	AtomsRenderer::setDefaultRenderingMethod((AtomsRenderer::RenderingMethod)defaultRenderingMethodBox->itemData(defaultRenderingMethodBox->currentIndex()).toInt());
	AtomsRenderer::setDefaultHQRenderingMethod((AtomsRenderer::RenderingMethod)defaultHQRenderingMethodBox->itemData(defaultHQRenderingMethodBox->currentIndex()).toInt());
}

};	// End of namespace AtomViz
