///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/actions/Action.h>
#include <core/actions/ActionProxy.h>

namespace Core {

IMPLEMENT_PLUGIN_CLASS(Action, PluginClass)

/******************************************************************************
* This function is called whenever the action is added to a
* container widget that supports custom widgets.
******************************************************************************/
QWidget* Action::createWidget(QWidget* parent)
{
	if(qobject_cast<QToolBar*>(parent)) {
		QToolButton* btn = new QToolButton(parent);
		btn->setDefaultAction(proxy());
		btn->setToolButtonStyle(qobject_cast<QToolBar*>(parent)->toolButtonStyle());
		return btn;
	}
	else if(qobject_cast<QMenu*>(parent) == NULL) {
		QPushButton* btn = new QPushButton(parent);
		btn->addAction(proxy());
	    btn->setCheckable(proxy()->isCheckable());
	    btn->setChecked(proxy()->isChecked());
	    btn->setEnabled(proxy()->isEnabled());
	    btn->setText(proxy()->text());
	    btn->setToolTip(proxy()->toolTip());
	    btn->setStatusTip(proxy()->statusTip());
	    btn->setWhatsThis(proxy()->whatsThis());
	    if(proxy()->isCheckable()) {
	    	connect(btn, SIGNAL(clicked(bool)), proxy(), SLOT(trigger()));
	    	connect(proxy(), SIGNAL(toggled(bool)), btn, SLOT(setChecked(bool)));
	    }
	    else {
	    	connect(btn, SIGNAL(clicked(bool)), proxy(), SLOT(trigger()));
	    }
	    return btn;
	}
	else return NULL;
}

};
