/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2005-2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 *
 * Thanks to Artur Kalimullin (Kaliy) <kalimullin@gmail.com> for assistance in LiteOn Cx scan implementation
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#include <stdio.h>
#include <stdlib.h>

#include <qpx_transport.h>
#include <qpx_mmc.h>
#include <common_functions.h>

#include <qscan_plugin.h>

// ************* Scan init commands *********
int scan_liteon::cmd_cd_errc_init() {
	dev->cmd[0] = 0xDF;
	dev->cmd[1] = 0xA3;
	if ((dev->err=dev->cmd.transport(READ,dev->rd_buf,256))){
		sperror ("LiteOn_init_A_cx_scan",dev->err); return 1;
	}
//	printf("LiteOn_init_A_cx_scan: OK\n");

	dev->cmd[0] = 0xDF;
	dev->cmd[1] = 0xA0;
	dev->cmd[4] = 0x02;
	if ((dev->err=dev->cmd.transport(READ,dev->rd_buf,256))){
		sperror ("LiteOn_init_B_cx_scan",dev->err); return 1;
	}
//	printf("LiteOn_init_B_cx_scan: OK\n");

	dev->cmd[0] = 0xDF;
	dev->cmd[1] = 0xA0;
	if ((dev->err=dev->cmd.transport(READ,dev->rd_buf,256))){
		sperror ("LiteOn_init_C_cx_scan",dev->err); return 1;
	}
//	printf("LiteOn_init_C_cx_scan: OK\n");

	dev->cmd[0] = 0xDF;
	dev->cmd[1] = 0xA0;
	dev->cmd[4] = 0x04;
	if ((dev->err=dev->cmd.transport(READ,dev->rd_buf,256))){
		sperror ("LiteOn_init_D_cx_scan",dev->err); return 1;
	}
//	printf("LiteOn_init_D_scan: OK\n");

	dev->cmd[0] = 0xDF;
	dev->cmd[1] = 0xA0;
	dev->cmd[4] = 0x02;
	if ((dev->err=dev->cmd.transport(READ,dev->rd_buf,256))){
		sperror ("LiteOn_init_E_cx_scan",dev->err); return 1;
	}
//	printf("LiteOn_init_E_cx_scan: OK\n");
	return 0;
}

int scan_liteon::cmd_dvd_errc_init() {
// 2B 00 00 00 00 00 00 00 00 00
	dev->cmd[0] = 0x2B;
	if ((dev->err=dev->cmd.transport(NONE,NULL,0))){
		sperror ("LiteOn_init_pi_scan",dev->err); return 1;
	}
//	printf("LiteOn_init_pi_scan: OK\n");
	return 0;
}

int scan_liteon::cmd_dvd_fete_init() {
// scan command
	dev->cmd[0] = 0xDF;
	dev->cmd[1] = 0x08;
	dev->cmd[2] = 0x01;

	dev->cmd[3] = 0x03;
/*
	dev->cmd[3] = ((lba+0x031000) >> 16) & 0xFF;
	dev->cmd[4] = ((lba+0x0100) >>  8) & 0xFF;
	dev->cmd[5] = lba & 0xFF;
*/
	dev->cmd[7] = 0x08; // speed or interval ? 
	dev->cmd[8] = 0x00; // 8X or 4M (2048 sectors)

	memset(dev->rd_buf,0,16);

	dev->rd_buf[0]  = 0x08;
	dev->rd_buf[1]  = 0x02;
	dev->rd_buf[4]  = 0x25;
	dev->rd_buf[5]  = 0x0F;
	dev->rd_buf[6]  = 0x02;
	dev->rd_buf[9]  = 0x03;
	dev->rd_buf[13] = 0x26;
	dev->rd_buf[14] = 0x12;
	dev->rd_buf[15] = 0x7F;


	if ((dev->err=dev->cmd.transport(WRITE,dev->rd_buf,16))){
		sperror ("LiteOn_FETE_init scan",dev->err); return 1;
	}

// fe/te data redout
	dev->cmd[0] = 0xDF;
	dev->cmd[1] = 0x08;
	dev->cmd[2] = 0x02;
	if ((dev->err=dev->cmd.transport(READ,dev->rd_buf,65536))){
		sperror ("LiteOn_FETE_init get data",dev->err); return 1;
	}

// current lba redout
	dev->cmd[0] = 0xDF;
	dev->cmd[1] = 0x02;
	dev->cmd[2] = 0x09;
	if ((dev->err=dev->cmd.transport(READ,dev->rd_buf,65536))){
		sperror ("LiteOn_FETE_init get LBA",dev->err); return 1;
	}
	int tlba = (dev->rd_buf[0] << 16) | (dev->rd_buf[1] << 8) | dev->rd_buf[2];
	printf("tlba = %d\n", tlba);
	return 0;
}


// ********************** CD ERRC commands


int scan_liteon::cmd_cd_errc_read() {
	dev->cmd[0] = 0xDF;
	dev->cmd[1] = 0x82;
	dev->cmd[2] = 0x09;
	if ((dev->err=dev->cmd.transport(READ,dev->rd_buf,256))){
		sperror ("LiteOn_cx_do_one_interval_scan",dev->err); return 1;
	}
//	printf("LiteOn_cx_do_one_interval_scan: OK");
	return 0;
}

int scan_liteon::cmd_cd_errc_getdata(cd_errc* data) {
	dev->cmd[0] = 0xDF;
	dev->cmd[1] = 0x82;
	dev->cmd[2] = 0x05;
	if ((dev->err=dev->cmd.transport(READ,dev->rd_buf,256))){
		sperror ("LiteOn_cx_do_one_interval_readout",dev->err); return 1;
	}
//	printf("LiteOn_cx_do_one_interval_readout: OK");
#if 0
	for (int i=0; i<32; i++) {
	    printf(" %02X",dev->rd_buf[i]);
	}
	printf("\n");
#endif
	data->bler = ntoh16(dev->rd_buf);
	data->e11 = 0;
	data->e21 = 0;
	data->e31 = 0;
	data->e12 = 0;
	data->e22 = ntoh16(dev->rd_buf+2);
//	data->e32 = ntoh16(dev->rd_buf+4);
	data->e32 = dev->rd_buf[4];
	data->uncr = 0;
	return 0;
}

int scan_liteon::cmd_cd_errc_inteval_rst() {
	dev->cmd[0] = 0xDF;
	dev->cmd[1] = 0x97;
	if ((dev->err=dev->cmd.transport(READ,dev->rd_buf,256))){
		sperror ("LiteOn_cx_do_one_interval_rst",dev->err); return 1;
	}
	return 0;
}

// ********************** DVD ERRC commands
int scan_liteon::cmd_cd_errc_block(cd_errc *data)
{
	if (cmd_cd_errc_read()) return dev->err;
	if (cmd_cd_errc_getdata(data)) return dev->err;
	lba+=75;
	if (cmd_cd_errc_inteval_rst()) return dev->err;
//	printf("LiteOn_cx_do_one_interval_rst: OK");
	return 0;
}


int scan_liteon::cmd_dvd_errc_block(dvd_errc *data)
{
//	int i;
//	*pie = 0;

	dev->cmd[0] = 0xF3;
	dev->cmd[1] = 0x0E;
	dev->cmd[8] = 0x10;
	if ((dev->err=dev->cmd.transport(READ,dev->rd_buf,10))){
		sperror ("LiteOn_pi_do_one_interval_scan",dev->err); return 1;
	}
#if 0
	for (int i=0; i<10; i++) {
	    printf(" %02X",dev->rd_buf[i]);
	}
	printf("\n");
#endif

// Data Received:
// 00000000  00 00 00 8E 00 00 00 00                           .......        
//	lba+=16;

//	lba = ((dev->rd_buf[1] << 16 )& 0xFF0000) + ((dev->rd_buf[2] << 8)&0xFF00 ) + (dev->rd_buf[3] & 0xFF);
	lba = ntoh32(dev->rd_buf);

	data->pie = ntoh16(dev->rd_buf+4);
//	data->pi8 = 0;
	data->pif = ntoh16(dev->rd_buf+6);
	data->poe = 0;
//	data->po8 = 0;
	data->pof = 0;
	return 0;
}

// *************** FE/TE    scan block
int scan_liteon::cmd_dvd_fete_block(cdvd_ft *data) {
// scan command
	dev->cmd[0] = 0xDF;
	dev->cmd[1] = 0x08;
	dev->cmd[2] = 0x01;
	dev->cmd[3] = ((lba+0x031000) >> 16) & 0xFF;
	dev->cmd[4] = ((lba+0x0100) >>  8) & 0xFF;
	dev->cmd[5] = lba & 0xFF;

	dev->cmd[7] = 0x10; // speed or interval ? 
	dev->cmd[8] = 0x00; // 16X or 8M (4096 sectors)

	memset(dev->rd_buf,0,16);

	if (!lba) {
		dev->rd_buf[0]  = 0x08;
		dev->rd_buf[1]  = 0x02;
		dev->rd_buf[4]  = 0x25;
		dev->rd_buf[5]  = 0x0F;
		dev->rd_buf[6]  = 0x02;
		dev->rd_buf[9]  = 0x03;
		dev->rd_buf[13] = 0x26;
		dev->rd_buf[14] = 0x05;
		dev->rd_buf[15] = 0x3F;
	} else {
		dev->rd_buf[0] = (lba >> 16) & 0xFF;
		dev->rd_buf[1] = (lba >>  8) & 0xFF;
		dev->rd_buf[2] = lba & 0xFF;

		dev->rd_buf[3] = 0x01;
		dev->rd_buf[5] = 0x04;
		dev->rd_buf[6] = 0x61;
		dev->rd_buf[7] = 0x01;
	}

	if ((dev->err=dev->cmd.transport(WRITE,dev->rd_buf,16))){
		sperror ("LiteOn_FETE scan",dev->err); return 1;
	}

// fe/te data redout
	dev->cmd[0] = 0xDF;
	dev->cmd[1] = 0x08;
	dev->cmd[2] = 0x02;
	if ((dev->err=dev->cmd.transport(READ,dev->rd_buf,65536))){
		sperror ("LiteOn_FETE get data",dev->err); return 1;
	}
	data->te=dev->rd_buf[0];
	data->fe=dev->rd_buf[1];

// current lba redout
	dev->cmd[0] = 0xDF;
	dev->cmd[1] = 0x02;
	dev->cmd[2] = 0x09;
	if ((dev->err=dev->cmd.transport(READ,dev->rd_buf,65536))){
		sperror ("LiteOn_FETE get LBA",dev->err); return 1;
	}
	lba = (dev->rd_buf[0] << 16) | (dev->rd_buf[1] << 8) | dev->rd_buf[2];

	return 0;
}

// ************* END SCAN COMMANDS *********
int scan_liteon::cmd_cd_errc_end() {
	dev->cmd[0] = 0xDF;
	dev->cmd[1] = 0xA3;
	dev->cmd[2] = 0x01;
	if ((dev->err=dev->cmd.transport(READ,dev->rd_buf,256))){
		sperror ("LiteOn_end_scan",dev->err); return 1;
	}
	return 0;
}

int scan_liteon::cmd_dvd_errc_end() {
	dev->err = 0;
	return 0;
}

