/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FAKEVIDEODEVICESELECTORCONTROL_H
#define FAKEVIDEODEVICESELECTORCONTROL_H

#include <QVideoDeviceSelectorControl>

class FakeCameraService;

class FakeVideoDeviceSelectorControl : public QVideoDeviceSelectorControl
{
public:
    FakeVideoDeviceSelectorControl(FakeCameraService *service, QObject *parent = 0);

    int defaultDevice() const;
    int deviceCount() const;
    QString deviceDescription(int index) const;
    QString deviceName(int index) const;
    int selectedDevice() const;

public Q_SLOTS:
    void setSelectedDevice(int index);

private:
    FakeCameraService *m_service;
    int m_currentCamera;
};

#endif // FAKEVIDEODEVICESELECTORCONTROL_H
