/*
 * Copyright (c) 2002-2009 Moxie Marlinspike
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __FIREFOX_UPDATER_H__
#define __FIREFOX_UPDATER_H__

#include "HTTPSBridge.hpp"
#include <boost/shared_ptr.hpp>

using namespace boost::asio;

class FirefoxUpdateException : public std::exception {
public:
  virtual const char* what() const throw() {
    return "Error processing firefox update request...";
  }
};

class FirefoxUpdater : public HTTPSBridge {

protected:
  virtual ip::tcp::endpoint getRemoteEndpoint();

private:

  std::string product;
  std::string version;
  std::string buildId;
  std::string buildTarget;
  std::string locale;
  std::string channel;
  std::string filename;

  ip::tcp::endpoint &destination;

protected:

  virtual bool parseMetaRequest(std::string &request);

public:
  FirefoxUpdater(boost::shared_ptr<ip::tcp::socket> clientSocket,
		 ip::tcp::endpoint &destination)
    : HTTPSBridge(clientSocket, NULL), destination(destination)

  {}

  virtual void sendMetaUpdateResponse();
  void readMetaUpdateRequest();
  virtual void close();
};

#endif
