#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '2.4.4'
__CHEETAH_versionTuple__ = (2, 4, 4, 'development', 0)
__CHEETAH_genTime__ = 1413234541.385449
__CHEETAH_genTimestamp__ = 'Tue Oct 14 08:09:01 2014'
__CHEETAH_src__ = '/Users/graham/Library/XMDS/src/xmds2/admin/staging/xmds-2.2.2/xpdeint/xsil2graphics2/MatlabOctaveImport.tmpl'
__CHEETAH_srcLastModified__ = 'Thu Nov 21 19:01:13 2013'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class MatlabOctaveImport(Template):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(MatlabOctaveImport, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def description(self, **KWS):



        ## Generated from @def description: Creates text to import data from XSIL files into Matlab or Octave (where they are identical). at line 24, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''Creates text to import data from XSIL files into Matlab or Octave (where they are identical).''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def printMatlabListOrElement(self, listOrElement, currentDepth, **KWS):



        ## CHEETAH: generated from @def printMatlabListOrElement(listOrElement, currentDepth) at line 30, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        #  This is a function to turn an array into a Matlab list.  Called recursively, and assumes the elements are floats or lists.
        if isinstance(listOrElement,float): # generated from line 32, col 3
            _v = VFFSL(SL,"format",False)(float(listOrElement),VFFSL(SL,"stringFormat",True)) # u'${format(float(listOrElement),$stringFormat)}' on line 33, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'${format(float(listOrElement),$stringFormat)}')) # from line 33, col 1.
        else: # generated from line 34, col 3
            write(u'''cat(''')
            _v = VFFSL(SL,"currentDepth",True) # u'$currentDepth' on line 35, col 5
            if _v is not None: write(_filter(_v, rawExpr=u'$currentDepth')) # from line 35, col 5.
            write(u''', ''')
            _v = ', '.join([VFFSL(SL,"printMatlabListOrElement",False)(element, currentDepth - 1) for element in listOrElement]) # u"${', '.join([$printMatlabListOrElement(element, currentDepth - 1) for element in listOrElement])}" on line 35, col 20
            if _v is not None: write(_filter(_v, rawExpr=u"${', '.join([$printMatlabListOrElement(element, currentDepth - 1) for element in listOrElement])}")) # from line 35, col 20.
            write(u''')''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def permuteDimensionsOfMATLABVariable(self, varName, **KWS):



        ## CHEETAH: generated from @def permuteDimensionsOfMATLABVariable(varName) at line 39, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        _v = VFFSL(SL,"varName",True) # u'${varName}' on line 40, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${varName}')) # from line 40, col 1.
        write(u''' = permute(''')
        _v = VFFSL(SL,"varName",True) # u'${varName}' on line 40, col 22
        if _v is not None: write(_filter(_v, rawExpr=u'${varName}')) # from line 40, col 22.
        write(u''', ndims(''')
        _v = VFFSL(SL,"varName",True) # u'${varName}' on line 40, col 40
        if _v is not None: write(_filter(_v, rawExpr=u'${varName}')) # from line 40, col 40.
        write(u'''):-1:1);
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def generateVariableName(self, xsilVariable, xsilObjectNumber, **KWS):



        ## CHEETAH: generated from @def generateVariableName(xsilVariable, xsilObjectNumber) at line 43, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        return ''.join([str(VFFSL(SL,"xsilVariable.name",True)),u'_',str(VFFSL(SL,"xsilObjectNumber",True)+1)])
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def loadXSILFile(self, xsilFile, **KWS):



        ## CHEETAH: generated from @def loadXSILFile($xsilFile) at line 47, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        for objectNum, xsilObject in enumerate(xsilFile.xsilObjects): # generated from line 48, col 3
            if xsilObject.data.format == 'ascii': # generated from line 49, col 5
                _v = VFFSL(SL,"handleASCIIXSILObject",False)(objectNum, xsilObject) # u'${handleASCIIXSILObject(objectNum, xsilObject)}' on line 50, col 1
                if _v is not None: write(_filter(_v, rawExpr=u'${handleASCIIXSILObject(objectNum, xsilObject)}')) # from line 50, col 1.
            elif xsilObject.data.format == 'binary': # generated from line 51, col 5
                _v = VFFSL(SL,"handleBinaryXSILObject",False)(objectNum, xsilObject) # u'${handleBinaryXSILObject(objectNum, xsilObject)}' on line 52, col 1
                if _v is not None: write(_filter(_v, rawExpr=u'${handleBinaryXSILObject(objectNum, xsilObject)}')) # from line 52, col 1.
            elif xsilObject.data.format == 'hdf5': # generated from line 53, col 5
                _v = VFFSL(SL,"handleHDF5XSILObject",False)(objectNum, xsilObject) # u'${handleHDF5XSILObject(objectNum, xsilObject)}' on line 54, col 1
                if _v is not None: write(_filter(_v, rawExpr=u'${handleHDF5XSILObject(objectNum, xsilObject)}')) # from line 54, col 1.
            else: # generated from line 55, col 5
                raise Exception("No support for Matlab/Octave output for XSIL format '%s'." % xsilObject.data.format)
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def handleASCIIXSILObject(self, objectNum, xsilObject, **KWS):



        ## CHEETAH: generated from @def handleASCIIXSILObject(objectNum, xsilObject) at line 61, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        nIndepVar = len(xsilObject.independentVariables)
        for var in xsilObject.independentVariables: # generated from line 63, col 3
            varName = VFFSL(SL,"generateVariableName",False)(var, objectNum)
            write(u'''clear ''')
            _v = VFFSL(SL,"varName",True) # u'$varName' on line 65, col 7
            if _v is not None: write(_filter(_v, rawExpr=u'$varName')) # from line 65, col 7.
            write(u'''
''')
            _v = VFFSL(SL,"varName",True) # u'$varName' on line 66, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'$varName')) # from line 66, col 1.
            write(u''' = [''')
            _v = ', '.join([format(float(e),VFFSL(SL,"stringFormat",True)) for e in var["array"]]) # u'${\', \'.join([format(float(e),$stringFormat) for e in var["array"]])}' on line 66, col 13
            if _v is not None: write(_filter(_v, rawExpr=u'${\', \'.join([format(float(e),$stringFormat) for e in var["array"]])}')) # from line 66, col 13.
            write(u'''];
''')
        for var in xsilObject.dependentVariables: # generated from line 68, col 3
            varName = VFFSL(SL,"generateVariableName",False)(var, objectNum)
            write(u'''clear ''')
            _v = VFFSL(SL,"varName",True) # u'$varName' on line 70, col 7
            if _v is not None: write(_filter(_v, rawExpr=u'$varName')) # from line 70, col 7.
            write(u'''
''')
            if nIndepVar == 1: # generated from line 71, col 5
                _v = VFFSL(SL,"varName",True) # u'$varName' on line 72, col 1
                if _v is not None: write(_filter(_v, rawExpr=u'$varName')) # from line 72, col 1.
                write(u''' = [''')
                _v = ', '.join([format(float(e), VFFSL(SL,"stringFormat",True)) for e in var["array"]]) # u'${\', \'.join([format(float(e), $stringFormat) for e in var["array"]])}' on line 72, col 13
                if _v is not None: write(_filter(_v, rawExpr=u'${\', \'.join([format(float(e), $stringFormat) for e in var["array"]])}')) # from line 72, col 13.
                write(u'''];
''')
            elif nIndepVar == 2: # generated from line 73, col 5
                _v = VFFSL(SL,"varName",True) # u'$varName' on line 74, col 1
                if _v is not None: write(_filter(_v, rawExpr=u'$varName')) # from line 74, col 1.
                write(u''' = [''')
                _v = ';'.join([(','.join([format(float(val), VFFSL(SL,"stringFormat",True)) for val in subArray])) for subArray in var["array"]]) # u'${\';\'.join([(\',\'.join([format(float(val), $stringFormat) for val in subArray])) for subArray in var["array"]])}' on line 74, col 13
                if _v is not None: write(_filter(_v, rawExpr=u'${\';\'.join([(\',\'.join([format(float(val), $stringFormat) for val in subArray])) for subArray in var["array"]])}')) # from line 74, col 13.
                write(u'''];
''')
            else: # generated from line 75, col 5
                _v = VFFSL(SL,"varName",True) # u'$varName' on line 76, col 1
                if _v is not None: write(_filter(_v, rawExpr=u'$varName')) # from line 76, col 1.
                write(u''' = ''')
                _v = VFFSL(SL,"printMatlabListOrElement",False)(VFFSL(SL,"var",True)["array"], VFFSL(SL,"nIndepVar",True)) # u'$printMatlabListOrElement($var["array"], $nIndepVar)' on line 76, col 12
                if _v is not None: write(_filter(_v, rawExpr=u'$printMatlabListOrElement($var["array"], $nIndepVar)')) # from line 76, col 12.
                write(u''';
''')
            _v = VFFSL(SL,"permuteDimensionsOfMATLABVariable",False)(varName) # u'${permuteDimensionsOfMATLABVariable(varName)}' on line 78, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'${permuteDimensionsOfMATLABVariable(varName)}')) # from line 78, col 1.
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def handleBinaryXSILObject(self, objectNum, xsilObject, **KWS):



        ## CHEETAH: generated from @def handleBinaryXSILObject(objectNum, xsilObject) at line 82, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        variablesToClear = ['fpDat', 'xmds_variableShape']
        nIndepVar = len(xsilObject.independentVariables)
        machineFormat = {'BigEndian': 'ieee-be', 'LittleEndian': 'ieee-le'}.get(xsilObject.data.encoding, 'native')
        uLongFormat = {'uint32': 'uint32', 'uint64': 'uint64'}.get(xsilObject.data.uLong, 'uint64')
        outputPrecision = {'single': 'single', 'double': 'double'}.get(xsilObject.data.precision, 'double')
        write(u"""fpDat = fopen('""")
        _v = VFFSL(SL,"xsilObject.data.filename",True) # u'$xsilObject.data.filename' on line 88, col 16
        if _v is not None: write(_filter(_v, rawExpr=u'$xsilObject.data.filename')) # from line 88, col 16.
        write(u"""','r', '""")
        _v = VFFSL(SL,"machineFormat",True) # u'$machineFormat' on line 88, col 49
        if _v is not None: write(_filter(_v, rawExpr=u'$machineFormat')) # from line 88, col 49.
        write(u"""');
if (fpDat < 0)
  disp('Cannot open binary data file: """)
        _v = VFFSL(SL,"xsilObject.data.filename",True) # u'${xsilObject.data.filename}' on line 90, col 39
        if _v is not None: write(_filter(_v, rawExpr=u'${xsilObject.data.filename}')) # from line 90, col 39.
        write(u"""');
  return;
end
xmds_variableShape = [];
""")
        for var in xsilObject.independentVariables: # generated from line 94, col 3
            varName = VFFSL(SL,"generateVariableName",False)(var, objectNum)
            variablesToClear.append(''.join([str(VFFSL(SL,"varName",True)),u'Len']))
            _v = VFFSL(SL,"varName",True) # u'$(varName)' on line 97, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'$(varName)')) # from line 97, col 1.
            write(u"""Len = fread(fpDat, 1, '""")
            _v = VFFSL(SL,"uLongFormat",True) # u'$uLongFormat' on line 97, col 34
            if _v is not None: write(_filter(_v, rawExpr=u'$uLongFormat')) # from line 97, col 34.
            write(u"""');
""")
            _v = VFFSL(SL,"varName",True) # u'$(varName)' on line 98, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'$(varName)')) # from line 98, col 1.
            write(u''' = fread(fpDat, ''')
            _v = VFFSL(SL,"varName",True) # u'$(varName)' on line 98, col 27
            if _v is not None: write(_filter(_v, rawExpr=u'$(varName)')) # from line 98, col 27.
            write(u"""Len, '""")
            _v = VFFSL(SL,"outputPrecision",True) # u'$outputPrecision' on line 98, col 43
            if _v is not None: write(_filter(_v, rawExpr=u'$outputPrecision')) # from line 98, col 43.
            write(u"""');
xmds_variableShape = [""")
            _v = VFFSL(SL,"varName",True) # u'${varName}' on line 99, col 23
            if _v is not None: write(_filter(_v, rawExpr=u'${varName}')) # from line 99, col 23.
            write(u'''Len xmds_variableShape];
''')
        write(u'''if (length(xmds_variableShape) == 0)
  xmds_variableShape = [1 1];
elseif (length(xmds_variableShape) == 1)
  xmds_variableShape(end+1) = 1;
end
''')
        for varD in xsilObject.dependentVariables: # generated from line 106, col 3
            varName = VFFSL(SL,"generateVariableName",False)(varD, objectNum)
            variablesToClear.append(''.join([str(VFFSL(SL,"varName",True)),u'Len']))
            _v = VFFSL(SL,"varName",True) # u'$(varName)' on line 109, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'$(varName)')) # from line 109, col 1.
            write(u"""Len = fread(fpDat, 1, '""")
            _v = VFFSL(SL,"uLongFormat",True) # u'$uLongFormat' on line 109, col 34
            if _v is not None: write(_filter(_v, rawExpr=u'$uLongFormat')) # from line 109, col 34.
            write(u"""', 0, '""")
            _v = VFFSL(SL,"machineFormat",True) # u'$machineFormat' on line 109, col 53
            if _v is not None: write(_filter(_v, rawExpr=u'$machineFormat')) # from line 109, col 53.
            write(u"""');
""")
            _v = VFFSL(SL,"varName",True) # u'$varName' on line 110, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'$varName')) # from line 110, col 1.
            write(u''' = fread(fpDat, ''')
            _v = VFFSL(SL,"varName",True) # u'$(varName)' on line 110, col 25
            if _v is not None: write(_filter(_v, rawExpr=u'$(varName)')) # from line 110, col 25.
            write(u"""Len, '""")
            _v = VFFSL(SL,"outputPrecision",True) # u'$outputPrecision' on line 110, col 41
            if _v is not None: write(_filter(_v, rawExpr=u'$outputPrecision')) # from line 110, col 41.
            write(u"""');
""")
            _v = VFFSL(SL,"varName",True) # u'$varName' on line 111, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'$varName')) # from line 111, col 1.
            write(u''' = reshape(''')
            _v = VFFSL(SL,"varName",True) # u'$varName' on line 111, col 20
            if _v is not None: write(_filter(_v, rawExpr=u'$varName')) # from line 111, col 20.
            write(u''', xmds_variableShape);
''')
            _v = VFFSL(SL,"permuteDimensionsOfMATLABVariable",False)(varName) # u'${permuteDimensionsOfMATLABVariable(varName)}' on line 112, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'${permuteDimensionsOfMATLABVariable(varName)}')) # from line 112, col 1.
        write(u'''fclose(fpDat);
clear ''')
        _v = ' '.join(variablesToClear) # u"${' '.join(variablesToClear)}" on line 115, col 7
        if _v is not None: write(_filter(_v, rawExpr=u"${' '.join(variablesToClear)}")) # from line 115, col 7.
        write(u'''
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def handleHDF5XSILObject(self, objectNum, xsilObject, **KWS):



        ## CHEETAH: generated from @def handleHDF5XSILObject(objectNum, xsilObject) at line 118, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u"""if (exist('OCTAVE_VERSION', 'builtin')) % Octave
  """)
        _v = VFFSL(SL,"handleHDF5XSILObjectForOctave",False)(objectNum, xsilObject) # u'${handleHDF5XSILObjectForOctave(objectNum, xsilObject), autoIndent=True}' on line 120, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr=u'${handleHDF5XSILObjectForOctave(objectNum, xsilObject), autoIndent=True}')) # from line 120, col 3.
        write(u'''else % MATLAB
  ''')
        _v = VFFSL(SL,"handleHDF5XSILObjectForMATLAB",False)(objectNum, xsilObject) # u'${handleHDF5XSILObjectForMATLAB(objectNum, xsilObject), autoIndent=True}' on line 122, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr=u'${handleHDF5XSILObjectForMATLAB(objectNum, xsilObject), autoIndent=True}')) # from line 122, col 3.
        write(u'''end
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def handleHDF5XSILObjectForMATLAB(self, objectNum, xsilObject, **KWS):



        ## CHEETAH: generated from @def handleHDF5XSILObjectForMATLAB(objectNum, xsilObject) at line 127, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        filename = xsilObject.data.filename
        groupName = xsilObject.data.groupName
        for var in xsilObject.independentVariables: # generated from line 130, col 3
            outName = VFFSL(SL,"generateVariableName",False)(var, objectNum)
            _v = VFFSL(SL,"outName",True) # u'${outName}' on line 132, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'${outName}')) # from line 132, col 1.
            write(u""" = hdf5read('""")
            _v = VFFSL(SL,"filename",True) # u'${filename}' on line 132, col 24
            if _v is not None: write(_filter(_v, rawExpr=u'${filename}')) # from line 132, col 24.
            write(u"""', '""")
            _v = VFFSL(SL,"groupName",True) # u'${groupName}' on line 132, col 39
            if _v is not None: write(_filter(_v, rawExpr=u'${groupName}')) # from line 132, col 39.
            write(u'''/''')
            _v = VFFSL(SL,"var.name",True) # u'${var.name}' on line 132, col 52
            if _v is not None: write(_filter(_v, rawExpr=u'${var.name}')) # from line 132, col 52.
            write(u"""');
""")
        for var in xsilObject.dependentVariables: # generated from line 134, col 3
            outName = VFFSL(SL,"generateVariableName",False)(var, objectNum)
            _v = VFFSL(SL,"outName",True) # u'${outName}' on line 136, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'${outName}')) # from line 136, col 1.
            write(u""" = hdf5read('""")
            _v = VFFSL(SL,"filename",True) # u'${filename}' on line 136, col 24
            if _v is not None: write(_filter(_v, rawExpr=u'${filename}')) # from line 136, col 24.
            write(u"""', '""")
            _v = VFFSL(SL,"groupName",True) # u'${groupName}' on line 136, col 39
            if _v is not None: write(_filter(_v, rawExpr=u'${groupName}')) # from line 136, col 39.
            write(u'''/''')
            _v = VFFSL(SL,"var.name",True) # u'${var.name}' on line 136, col 52
            if _v is not None: write(_filter(_v, rawExpr=u'${var.name}')) # from line 136, col 52.
            write(u"""');
""")
            _v = VFFSL(SL,"permuteDimensionsOfMATLABVariable",False)(outName) # u'${permuteDimensionsOfMATLABVariable(outName)}' on line 137, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'${permuteDimensionsOfMATLABVariable(outName)}')) # from line 137, col 1.
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def handleHDF5XSILObjectForOctave(self, objectNum, xsilObject, **KWS):



        ## CHEETAH: generated from @def handleHDF5XSILObjectForOctave(objectNum, xsilObject) at line 141, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        filename = xsilObject.data.filename
        variables = xsilObject.independentVariables[:]
        write(u'''load ''')
        _v = VFFSL(SL,"filename",True) # u'${filename}' on line 144, col 6
        if _v is not None: write(_filter(_v, rawExpr=u'${filename}')) # from line 144, col 6.
        write(u'''
''')
        for var in xsilObject.independentVariables: # generated from line 145, col 3
            outName = VFFSL(SL,"generateVariableName",False)(var, objectNum)
            #  We have to do an eval here because variables with leading underscores are not valid in MATLAB
            #  (although accepted by Octave), and the MATLAB parser dies if there are expressions with leading underscores.
            _v = VFFSL(SL,"outName",True) # u'${outName}' on line 149, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'${outName}')) # from line 149, col 1.
            write(u""" = eval('_""")
            _v = VFFSL(SL,"objectNum",True)+1 # u'${objectNum+1}' on line 149, col 21
            if _v is not None: write(_filter(_v, rawExpr=u'${objectNum+1}')) # from line 149, col 21.
            write(u'''.''')
            _v = VFFSL(SL,"var.name",True) # u'${var.name}' on line 149, col 36
            if _v is not None: write(_filter(_v, rawExpr=u'${var.name}')) # from line 149, col 36.
            write(u"""');
""")
        for var in xsilObject.dependentVariables: # generated from line 151, col 3
            outName = VFFSL(SL,"generateVariableName",False)(var, objectNum)
            _v = VFFSL(SL,"outName",True) # u'${outName}' on line 153, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'${outName}')) # from line 153, col 1.
            write(u""" = eval('_""")
            _v = VFFSL(SL,"objectNum",True)+1 # u'${objectNum+1}' on line 153, col 21
            if _v is not None: write(_filter(_v, rawExpr=u'${objectNum+1}')) # from line 153, col 21.
            write(u'''.''')
            _v = VFFSL(SL,"var.name",True) # u'${var.name}' on line 153, col 36
            if _v is not None: write(_filter(_v, rawExpr=u'${var.name}')) # from line 153, col 36.
            write(u"""');
""")
            _v = VFFSL(SL,"permuteDimensionsOfMATLABVariable",False)(outName) # u'${permuteDimensionsOfMATLABVariable(outName)}' on line 154, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'${permuteDimensionsOfMATLABVariable(outName)}')) # from line 154, col 1.
        write(u'''clear _''')
        _v = VFFSL(SL,"objectNum",True)+1 # u'${objectNum+1}' on line 156, col 8
        if _v is not None: write(_filter(_v, rawExpr=u'${objectNum+1}')) # from line 156, col 8.
        write(u''';
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def respond(self, trans=None):



        ## CHEETAH: main method generated for this template
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        # MatlabOctaveImport.tmpl
        # 
        # Created by Joe Hope on 2009-01-07.
        # Modified by Gregory Bogomiagkov and Liam Madge on 2013-07-18.
        # 
        # Copyright (c) 2009-2013, Joe Hope and Graham Dennis
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write(u'''












''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    defaultExtension = 'm'

    stringFormat = '.12e'

    name = 'MATLAB/Octave'

    _mainCheetahMethod_for_MatlabOctaveImport= 'respond'

## END CLASS DEFINITION

if not hasattr(MatlabOctaveImport, '_initCheetahAttributes'):
    templateAPIClass = getattr(MatlabOctaveImport, '_CHEETAH_templateClass', Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(MatlabOctaveImport)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit http://www.CheetahTemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=MatlabOctaveImport()).run()


