//
//  Goom.m
//  iGoom
//
//  Created by Guillaume Borios on Sat Dec 20 2003.
//  Copyright (c) 2003 iOS. All rights reserved.
//

#import "Goom.h"


@implementation Goom

-(Goom*)init
{
    self = [super init];
    
    if (self != nil)
    {
        goomInfos = goom_init(16, 16);
    }
    return self;
}

-(Goom*)initWithSize:(NSSize)_size
{
    self = [super init];
    
    if (self != nil)
    {
        goomInfos = goom_init(_size.width, _size.height);
    }
    return self;
}

- (PluginInfo*)infos
{
    return goomInfos;
}

-(void)setSize:(NSSize)_size
{
    goom_set_resolution (goomInfos, _size.width, _size.height);
}

-(guint32 *)getGoomDataWithFPS:(float)fps
{
    return goom_update(goomInfos, sndData, 0, fps, 0, 0);
}

- (void)dealloc
{
    goom_close(goomInfos);
    
    [super dealloc];
}



@end
