/////////////////////////////////////////////////////////////////////////////
// Name:        _????.i
// Purpose:     SWIG interface for wx????
//
// Author:      Robin Dunn
//
// Created:     9-Aug-2003
// RCS-ID:      $Id: _printfw.i,v 1.6 2003/12/20 01:01:36 RD Exp $
// Copyright:   (c) 2003 by Total Control Software
// Licence:     wxWindows license
/////////////////////////////////////////////////////////////////////////////

// Not a %module


//---------------------------------------------------------------------------
%newgroup

%{
#include "wx/wxPython/printfw.h"

%}

MAKE_CONST_WXSTRING2(PrintoutTitleStr, wxT("Printout"));
MAKE_CONST_WXSTRING2(PreviewCanvasNameStr, wxT("previewcanvas"));


//---------------------------------------------------------------------------

enum wxPrintMode
{
    wxPRINT_MODE_NONE =    0,
    wxPRINT_MODE_PREVIEW = 1,   // Preview in external application
    wxPRINT_MODE_FILE =    2,   // Print to file
    wxPRINT_MODE_PRINTER = 3    // Send to printer
};



class wxPrintData : public wxObject {
public:
    wxPrintData();
    ~wxPrintData();

    int GetNoCopies();
    bool GetCollate();
    int  GetOrientation();

    bool Ok();

    const wxString& GetPrinterName();
    bool GetColour();
    wxDuplexMode GetDuplex();
    wxPaperSize GetPaperId();
    const wxSize& GetPaperSize();

    int GetQuality();

    void SetNoCopies(int v);
    void SetCollate(bool flag);
    void SetOrientation(int orient);

    void SetPrinterName(const wxString& name);
    void SetColour(bool colour);
    void SetDuplex(wxDuplexMode duplex);
    void SetPaperId(wxPaperSize sizeId);
    void SetPaperSize(const wxSize& sz);
    void SetQuality(int quality);

    // PostScript-specific data
    const wxString& GetPrinterCommand();
    const wxString& GetPrinterOptions();
    const wxString& GetPreviewCommand();
    const wxString& GetFilename();
    const wxString& GetFontMetricPath();
    double GetPrinterScaleX();
    double GetPrinterScaleY();
    long GetPrinterTranslateX();
    long GetPrinterTranslateY();
    wxPrintMode GetPrintMode();

    void SetPrinterCommand(const wxString& command);
    void SetPrinterOptions(const wxString& options);
    void SetPreviewCommand(const wxString& command);
    void SetFilename(const wxString& filename);
    void SetFontMetricPath(const wxString& path);
    void SetPrinterScaleX(double x);
    void SetPrinterScaleY(double y);
    void SetPrinterScaling(double x, double y);
    void SetPrinterTranslateX(long x);
    void SetPrinterTranslateY(long y);
    void SetPrinterTranslation(long x, long y);
    void SetPrintMode(wxPrintMode printMode);

    %pythoncode { def __nonzero__(self): return self.Ok() }
};

//---------------------------------------------------------------------------

class wxPageSetupDialogData : public wxObject {
public:
    wxPageSetupDialogData();
    ~wxPageSetupDialogData();

    void EnableHelp(bool flag);
    void EnableMargins(bool flag);
    void EnableOrientation(bool flag);
    void EnablePaper(bool flag);
    void EnablePrinter(bool flag);
    bool GetDefaultMinMargins();
    bool GetEnableMargins();
    bool GetEnableOrientation();
    bool GetEnablePaper();
    bool GetEnablePrinter();
    bool GetEnableHelp();
    bool GetDefaultInfo();
    wxPoint GetMarginTopLeft();
    wxPoint GetMarginBottomRight();
    wxPoint GetMinMarginTopLeft();
    wxPoint GetMinMarginBottomRight();
    wxPaperSize GetPaperId();
    wxSize GetPaperSize();

    wxPrintData& GetPrintData();
//     %addmethods {
//         %new wxPrintData* GetPrintData() {
//             return new wxPrintData(self->GetPrintData());  // force a copy
//         }
//     }

    bool Ok();

    void SetDefaultInfo(bool flag);
    void SetDefaultMinMargins(bool flag);
    void SetMarginTopLeft(const wxPoint& pt);
    void SetMarginBottomRight(const wxPoint& pt);
    void SetMinMarginTopLeft(const wxPoint& pt);
    void SetMinMarginBottomRight(const wxPoint& pt);
    void SetPaperId(wxPaperSize id);
    void SetPaperSize(const wxSize& size);
    void SetPrintData(const wxPrintData& printData);

    %pythoncode { def __nonzero__(self): return self.Ok() }
};



class wxPageSetupDialog : public wxDialog {
public:
    %addtofunc wxPageSetupDialog         "self._setOORInfo(self)"

    wxPageSetupDialog(wxWindow* parent, wxPageSetupDialogData* data = NULL);

    wxPageSetupDialogData& GetPageSetupData();
    int ShowModal();
};

//---------------------------------------------------------------------------


class wxPrintDialogData : public wxObject {
public:
    wxPrintDialogData();
    ~wxPrintDialogData();

    int GetFromPage() const;
    int GetToPage() const;
    int GetMinPage() const;
    int GetMaxPage() const;
    int GetNoCopies() const;
    bool GetAllPages() const;
    bool GetSelection() const;
    bool GetCollate() const;
    bool GetPrintToFile() const;
    bool GetSetupDialog() const;

    void SetFromPage(int v);
    void SetToPage(int v);
    void SetMinPage(int v);
    void SetMaxPage(int v);
    void SetNoCopies(int v);
    void SetAllPages(bool flag);
    void SetSelection(bool flag);
    void SetCollate(bool flag);
    void SetPrintToFile(bool flag);
    void SetSetupDialog(bool flag);

    void EnablePrintToFile(bool flag);
    void EnableSelection(bool flag);
    void EnablePageNumbers(bool flag);
    void EnableHelp(bool flag);

    bool GetEnablePrintToFile() const;
    bool GetEnableSelection() const;
    bool GetEnablePageNumbers() const;
    bool GetEnableHelp() const;

    // Is this data OK for showing the print dialog?
    bool Ok() const;

    
    wxPrintData& GetPrintData();
//     %addmethods {
//         %new wxPrintData* GetPrintData() {
//             return new wxPrintData(self->GetPrintData());  // force a copy
//         }
//     }
    void SetPrintData(const wxPrintData& printData);

    %pythoncode { def __nonzero__(self): return self.Ok() }
};


class wxPrintDialog : public wxDialog {
public:
    %addtofunc wxPrintDialog         "self._setOORInfo(self)"

    wxPrintDialog(wxWindow* parent, wxPrintDialogData* data = NULL);

    wxPrintDialogData& GetPrintDialogData();

    %newobject GetPrintDC;
    wxDC* GetPrintDC();
    int ShowModal();
};


//---------------------------------------------------------------------------
//---------------------------------------------------------------------------


enum wxPrinterError
{
    wxPRINTER_NO_ERROR = 0,
    wxPRINTER_CANCELLED,
    wxPRINTER_ERROR
};


class wxPrinter : public wxObject {
public:
    wxPrinter(wxPrintDialogData* data = NULL);
    ~wxPrinter();

    void CreateAbortWindow(wxWindow* parent, wxPyPrintout* printout);
    wxPrintDialogData& GetPrintDialogData();
    bool Print(wxWindow *parent, wxPyPrintout *printout, int prompt=True);
    wxDC* PrintDialog(wxWindow *parent);
    void ReportError(wxWindow *parent, wxPyPrintout *printout, const wxString& message);
    bool Setup(wxWindow *parent);
    bool GetAbort();

    static wxPrinterError GetLastError();
};


//---------------------------------------------------------------------------
// Custom wxPrintout class that knows how to call python
%{


// Since this one would be tough and ugly to do with the Macros...
void wxPyPrintout::GetPageInfo(int *minPage, int *maxPage, int *pageFrom, int *pageTo) {
    bool hadErr = False;
    bool found;

    wxPyBeginBlockThreads();
    if ((found = wxPyCBH_findCallback(m_myInst, "GetPageInfo"))) {
        PyObject* result = wxPyCBH_callCallbackObj(m_myInst, Py_BuildValue("()"));
        if (result && PyTuple_Check(result) && PyTuple_Size(result) == 4) {
            PyObject* val;

            val = PyTuple_GetItem(result, 0);
            if (PyInt_Check(val))    *minPage = PyInt_AsLong(val);
            else hadErr = True;

            val = PyTuple_GetItem(result, 1);
            if (PyInt_Check(val))    *maxPage = PyInt_AsLong(val);
            else hadErr = True;

            val = PyTuple_GetItem(result, 2);
            if (PyInt_Check(val))    *pageFrom = PyInt_AsLong(val);
            else hadErr = True;

            val = PyTuple_GetItem(result, 3);
            if (PyInt_Check(val))    *pageTo = PyInt_AsLong(val);
            else hadErr = True;
        }
        else
            hadErr = True;

        if (hadErr) {
            PyErr_SetString(PyExc_TypeError, "GetPageInfo should return a tuple of 4 integers.");
            PyErr_Print();
        }
        Py_DECREF(result);
    }
    wxPyEndBlockThreads();
    if (! found)
        wxPrintout::GetPageInfo(minPage, maxPage, pageFrom, pageTo);
}

void wxPyPrintout::base_GetPageInfo(int *minPage, int *maxPage, int *pageFrom, int *pageTo) {
    wxPrintout::GetPageInfo(minPage, maxPage, pageFrom, pageTo);
}


IMP_PYCALLBACK_BOOL_INTINT(wxPyPrintout, wxPrintout, OnBeginDocument);
IMP_PYCALLBACK__(wxPyPrintout, wxPrintout, OnEndDocument);
IMP_PYCALLBACK__(wxPyPrintout, wxPrintout, OnBeginPrinting);
IMP_PYCALLBACK__(wxPyPrintout, wxPrintout, OnEndPrinting);
IMP_PYCALLBACK__(wxPyPrintout, wxPrintout, OnPreparePrinting);
IMP_PYCALLBACK_BOOL_INT_pure(wxPyPrintout, wxPrintout, OnPrintPage);
IMP_PYCALLBACK_BOOL_INT(wxPyPrintout, wxPrintout, HasPage);


%}


// Now define the custom class for SWIGging
%name(Printout) class wxPyPrintout  : public wxObject {
public:
    %addtofunc wxPyPrintout   "self._setCallbackInfo(self, Printout)"

    wxPyPrintout(const wxString& title = wxPyPrintoutTitleStr);
    //~wxPyPrintout();      wxPrintPreview object takes ownership...
    
    void _setCallbackInfo(PyObject* self, PyObject* _class);

    
    wxString GetTitle() const;
    wxDC* GetDC();
    void SetDC(wxDC *dc);

    void SetPageSizePixels(int w, int  h);
    DocDeclA(
        void, GetPageSizePixels(int *OUTPUT, int *OUTPUT),
        "GetPageSizePixels() -> (w, h)");

    void SetPageSizeMM(int w, int  h);
    DocDeclA(
        void, GetPageSizeMM(int *OUTPUT, int *OUTPUT),
        "GetPageSizeMM() -> (w, h)");
    
    void SetPPIScreen(int x, int y);
    DocDeclA(
        void, GetPPIScreen(int *OUTPUT, int *OUTPUT),
        "GetPPIScreen() -> (x,y)");
    
    void SetPPIPrinter(int x, int y);
    DocDeclA(
        void, GetPPIPrinter(int *OUTPUT, int *OUTPUT),
        "GetPPIPrinter() -> (x,y)");

    bool IsPreview();
    void SetIsPreview(bool p);

    
    bool base_OnBeginDocument(int startPage, int endPage);
    void base_OnEndDocument();
    void base_OnBeginPrinting();
    void base_OnEndPrinting();
    void base_OnPreparePrinting();
    bool base_HasPage(int page);
    DocDeclA(
        void, base_GetPageInfo(int *OUTPUT, int *OUTPUT, int *OUTPUT, int *OUTPUT),
        "base_GetPageInfo() -> (minPage, maxPage, pageFrom, pageTo)");
};

//---------------------------------------------------------------------------



class wxPreviewCanvas: public wxScrolledWindow
{
public:
    %addtofunc wxPreviewCanvas   "self._setOORInfo(self)"

    wxPreviewCanvas(wxPrintPreview *preview,
                    wxWindow *parent,
                    const wxPoint& pos = wxDefaultPosition,
                    const wxSize& size = wxDefaultSize,
                    long style = 0,
                    const wxString& name = wxPyPreviewCanvasNameStr);
};


class wxPreviewFrame : public wxFrame {
public:
    %addtofunc wxPreviewFrame   "self._setOORInfo(self)"

    wxPreviewFrame(wxPrintPreview* preview, wxFrame* parent, const wxString& title,
                   const wxPoint& pos = wxDefaultPosition,
                   const wxSize&  size = wxDefaultSize,
                   long style = wxDEFAULT_FRAME_STYLE,
                   const wxString& name = wxPyFrameNameStr);

    void Initialize();
    void CreateControlBar();
    void CreateCanvas();

    wxPreviewControlBar* GetControlBar() const;
};



enum {
    wxPREVIEW_PRINT,
    wxPREVIEW_PREVIOUS,
    wxPREVIEW_NEXT,
    wxPREVIEW_ZOOM,
    wxPREVIEW_FIRST,
    wxPREVIEW_LAST,
    wxPREVIEW_GOTO,
    wxPREVIEW_DEFAULT,

    wxID_PREVIEW_CLOSE,
    wxID_PREVIEW_NEXT,
    wxID_PREVIEW_PREVIOUS,
    wxID_PREVIEW_PRINT,
    wxID_PREVIEW_ZOOM,
    wxID_PREVIEW_FIRST,
    wxID_PREVIEW_LAST,
    wxID_PREVIEW_GOTO
};

class wxPreviewControlBar: public wxPanel
{
public:
    %addtofunc wxPreviewControlBar   "self._setOORInfo(self)"

    wxPreviewControlBar(wxPrintPreview *preview,
                        long buttons,
                        wxWindow *parent,
                        const wxPoint& pos = wxDefaultPosition,
                        const wxSize& size = wxDefaultSize,
                        long style = wxTAB_TRAVERSAL,
                        const wxString& name = wxPyPanelNameStr);

    int GetZoomControl();
    void SetZoomControl(int zoom);
    wxPrintPreview* GetPrintPreview();

    void OnNext();
    void OnPrevious();
    void OnFirst();
    void OnLast();
    void OnGoto();
};



//---------------------------------------------------------------------------

class wxPrintPreview : public wxObject {
public:
    wxPrintPreview(wxPyPrintout* printout,
                   wxPyPrintout* printoutForPrinting,
                   wxPrintData* data=NULL);

    virtual bool SetCurrentPage(int pageNum);
    int GetCurrentPage();

    void SetPrintout(wxPyPrintout *printout);
    wxPyPrintout *GetPrintout();
    wxPyPrintout *GetPrintoutForPrinting();

    void SetFrame(wxFrame *frame);
    void SetCanvas(wxPreviewCanvas *canvas);

    virtual wxFrame *GetFrame();
    virtual wxPreviewCanvas *GetCanvas();

    // The preview canvas should call this from OnPaint
    virtual bool PaintPage(wxPreviewCanvas *canvas, wxDC& dc);

    // This draws a blank page onto the preview canvas
    virtual bool DrawBlankPage(wxPreviewCanvas *canvas, wxDC& dc);

    // This is called by wxPrintPreview to render a page into a wxMemoryDC.
    virtual bool RenderPage(int pageNum);

    // Adjusts the scrollbars for the current scale
    virtual void AdjustScrollbars(wxPreviewCanvas *canvas);

    wxPrintDialogData& GetPrintDialogData();

    virtual void SetZoom(int percent);
    int GetZoom();

    int GetMaxPage();
    int GetMinPage();

    bool Ok();
    void SetOk(bool ok);

    virtual bool Print(bool interactive);
    virtual void DetermineScaling();

    %pythoncode { def __nonzero__(self): return self.Ok() }
};



//---------------------------------------------------------------------------

// Python-derivable versions of the above preview classes

%{

#define DEC_PYCALLBACK_BOOL_PREWINDC(CBNAME)                                    \
    bool CBNAME(wxPreviewCanvas* a, wxDC& b);                                   \
    bool base_##CBNAME(wxPreviewCanvas* a, wxDC& b)


#define IMP_PYCALLBACK_BOOL_PREWINDC(CLASS, PCLASS, CBNAME)                     \
    bool CLASS::CBNAME(wxPreviewCanvas* a, wxDC& b) {                           \
        bool rval=False;                                                        \
        bool found;                                                             \
        wxPyBeginBlockThreads();                                                \
        if ((found = wxPyCBH_findCallback(m_myInst, #CBNAME))) {                \
            PyObject* win = wxPyMake_wxObject(a);                               \
            PyObject* dc  = wxPyMake_wxObject(&b);                              \
            rval = wxPyCBH_callCallback(m_myInst, Py_BuildValue("(OO)", win, dc));\
            Py_DECREF(win);                                                     \
            Py_DECREF(dc);                                                      \
        }                                                                       \
        wxPyEndBlockThreads();                                                  \
        if (! found)                                                            \
            rval = PCLASS::CBNAME(a, b);                                        \
        return rval;                                                            \
    }                                                                           \
    bool CLASS::base_##CBNAME(wxPreviewCanvas* a, wxDC& b) {                    \
        return PCLASS::CBNAME(a, b);                                            \
    }




class wxPyPrintPreview : public wxPrintPreview
{
    DECLARE_CLASS(wxPyPrintPreview)
public:
    wxPyPrintPreview(wxPyPrintout* printout,
                     wxPyPrintout* printoutForPrinting,
                     wxPrintData* data=NULL)
        : wxPrintPreview(printout, printoutForPrinting, data)
    {}

    DEC_PYCALLBACK_BOOL_INT(SetCurrentPage);
    DEC_PYCALLBACK_BOOL_PREWINDC(PaintPage);
    DEC_PYCALLBACK_BOOL_PREWINDC(DrawBlankPage);
    DEC_PYCALLBACK_BOOL_INT(RenderPage);
    DEC_PYCALLBACK_VOID_INT(SetZoom);
    DEC_PYCALLBACK_BOOL_BOOL(Print);
    DEC_PYCALLBACK_VOID_(DetermineScaling);

    PYPRIVATE;
};

// Stupid renamed classes...  Fix this in 2.5...
#if defined(__WXMSW__)
IMPLEMENT_CLASS( wxPyPrintPreview, wxWindowsPrintPreview );
#elif defined(__WXMAC__)
IMPLEMENT_CLASS( wxPyPrintPreview, wxMacPrintPreview );
#else
IMPLEMENT_CLASS( wxPyPrintPreview, wxPostScriptPrintPreview );
#endif

IMP_PYCALLBACK_BOOL_INT     (wxPyPrintPreview, wxPrintPreview, SetCurrentPage);
IMP_PYCALLBACK_BOOL_PREWINDC(wxPyPrintPreview, wxPrintPreview, PaintPage);
IMP_PYCALLBACK_BOOL_PREWINDC(wxPyPrintPreview, wxPrintPreview, DrawBlankPage);
IMP_PYCALLBACK_BOOL_INT     (wxPyPrintPreview, wxPrintPreview, RenderPage);
IMP_PYCALLBACK_VOID_INT     (wxPyPrintPreview, wxPrintPreview, SetZoom);
IMP_PYCALLBACK_BOOL_BOOL    (wxPyPrintPreview, wxPrintPreview, Print);
IMP_PYCALLBACK_VOID_        (wxPyPrintPreview, wxPrintPreview, DetermineScaling);
%}


class wxPyPrintPreview : public wxPrintPreview
{
public:
    %addtofunc wxPyPrintPreview   "self._setCallbackInfo(self, PyPrintPreview)"

    wxPyPrintPreview(wxPyPrintout* printout,
                     wxPyPrintout* printoutForPrinting,
                     wxPrintData* data=NULL);

    void _setCallbackInfo(PyObject* self, PyObject* _class);
    
    bool base_SetCurrentPage(int pageNum);
    bool base_PaintPage(wxPreviewCanvas *canvas, wxDC& dc);
    bool base_DrawBlankPage(wxPreviewCanvas *canvas, wxDC& dc);
    bool base_RenderPage(int pageNum);
    void base_SetZoom(int percent);
    bool base_Print(bool interactive);
    void base_DetermineScaling();
};




%{
class wxPyPreviewFrame : public wxPreviewFrame
{
    DECLARE_CLASS(wxPyPreviewFrame);
public:
    wxPyPreviewFrame(wxPrintPreview* preview, wxFrame* parent,
                     const wxString& title,
                     const wxPoint& pos = wxDefaultPosition,
                     const wxSize&  size = wxDefaultSize,
                     long style = wxDEFAULT_FRAME_STYLE,
                     const wxString& name = wxPyFrameNameStr)
        : wxPreviewFrame(preview, parent, title, pos, size, style, name)
    {}

    void SetPreviewCanvas(wxPreviewCanvas* canvas) { m_previewCanvas = canvas; }
    void SetControlBar(wxPreviewControlBar* bar) { m_controlBar = bar; }

    DEC_PYCALLBACK_VOID_(Initialize);
    DEC_PYCALLBACK_VOID_(CreateCanvas);
    DEC_PYCALLBACK_VOID_(CreateControlBar);

    PYPRIVATE;
};

IMPLEMENT_CLASS(wxPyPreviewFrame, wxPreviewFrame);

IMP_PYCALLBACK_VOID_(wxPyPreviewFrame, wxPreviewFrame, Initialize);
IMP_PYCALLBACK_VOID_(wxPyPreviewFrame, wxPreviewFrame, CreateCanvas);
IMP_PYCALLBACK_VOID_(wxPyPreviewFrame, wxPreviewFrame, CreateControlBar);
%}


class wxPyPreviewFrame : public wxPreviewFrame
{
public:
    %addtofunc wxPyPreviewFrame "self._setCallbackInfo(self, PyPreviewFrame); self._setOORInfo(self)"

    wxPyPreviewFrame(wxPrintPreview* preview, wxFrame* parent,
                     const wxString& title,
                     const wxPoint& pos = wxDefaultPosition,
                     const wxSize&  size = wxDefaultSize,
                     long style = wxDEFAULT_FRAME_STYLE,
                     const wxString& name = wxPyFrameNameStr);

    void _setCallbackInfo(PyObject* self, PyObject* _class);

    void SetPreviewCanvas(wxPreviewCanvas* canvas);
    void SetControlBar(wxPreviewControlBar* bar);

    void base_Initialize();
    void base_CreateCanvas();
    void base_CreateControlBar();
};




%{
class wxPyPreviewControlBar : public wxPreviewControlBar
{
    DECLARE_CLASS(wxPyPreviewControlBar);
public:
    wxPyPreviewControlBar(wxPrintPreview *preview,
                          long buttons,
                          wxWindow *parent,
                          const wxPoint& pos = wxDefaultPosition,
                          const wxSize& size = wxDefaultSize,
                          long style = 0,
                          const wxString& name = wxPyPanelNameStr)
        : wxPreviewControlBar(preview, buttons, parent, pos, size, style, name)
    {}

    void SetPrintPreview(wxPrintPreview* preview) { m_printPreview = preview; }

    DEC_PYCALLBACK_VOID_(CreateButtons);
    DEC_PYCALLBACK_VOID_INT(SetZoomControl);

    PYPRIVATE;
};

IMPLEMENT_CLASS(wxPyPreviewControlBar, wxPreviewControlBar);
IMP_PYCALLBACK_VOID_(wxPyPreviewControlBar, wxPreviewControlBar, CreateButtons);
IMP_PYCALLBACK_VOID_INT(wxPyPreviewControlBar, wxPreviewControlBar, SetZoomControl);
%}


class wxPyPreviewControlBar : public wxPreviewControlBar
{
public:
    %addtofunc wxPyPreviewControlBar   "self._setCallbackInfo(self, PyPreviewControlBar); self._setOORInfo(self)"

    wxPyPreviewControlBar(wxPrintPreview *preview,
                          long buttons,
                          wxWindow *parent,
                          const wxPoint& pos = wxDefaultPosition,
                          const wxSize& size = wxDefaultSize,
                          long style = 0,
                          const wxString& name = wxPyPanelNameStr);

    void _setCallbackInfo(PyObject* self, PyObject* _class);

    void SetPrintPreview(wxPrintPreview* preview);

    void base_CreateButtons();
    void base_SetZoomControl(int zoom);
};


//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
%init %{
    wxPyPtrTypeMap_Add("wxPrintout", "wxPyPrintout");
%}
//---------------------------------------------------------------------------
