/*****************************************************************************
 * socket.h: VideoLAN Channel Server network facilities
 *****************************************************************************
 * Copyright (C) 2001 VideoLAN
 * $Id: socket.h,v 1.5 2002/06/09 17:56:17 marcari Exp $
 *
 * Authors: Marc Ariberti <marcari@via.ecp.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

class C_Socket
{
public:
    C_Socket(C_Logger &logger);
    virtual int Receive( char * p_buffer, int buffer_len ) = 0;
    virtual void Reply( char * psz_message ) = 0;
    virtual void Close( int i_ret );

    virtual const char * Ntop( ) = 0;
    
    int i_handle;
    C_Logger &logger;
};

class C_IPv4Socket : public C_Socket
{
public:
    C_IPv4Socket( C_Logger &logger, int port, char * bind_addr = NULL )
            throw (int);
    virtual int Receive( char * p_buffer, int buffer_len );
    virtual void Reply( char * psz_message );
    virtual const char * Ntop( );

protected:
    sockaddr_in m_sa_client;
    char str[INET_ADDRSTRLEN];
};

class C_IPv6Socket : public C_Socket
{
public:
    C_IPv6Socket( C_Logger &logger, int port, char * bind_addr = NULL )
            throw(int);
    virtual int Receive( char * p_buffer, int buffer_len );
    virtual void Reply( char * psz_message );
    virtual const char * Ntop( );

protected:
    sockaddr_in6 m_sa_client;
    char str[INET6_ADDRSTRLEN];
};
