/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.web.medias;

import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.medias.VlMedia;

public class TNTChannelRemoveValidator implements Validator {

    public boolean supports(Class arg0) {
        return (arg0.equals(TNTChannelAdd.class));
    }

    public void validate(Object arg0, Errors arg1)
    {
        TNTChannelAdd channelToRemoveModel = (TNTChannelAdd) arg0;
        IVlData data = channelToRemoveModel.getData();

        if (channelToRemoveModel == null) {
            arg1.rejectValue("Id",
                    "medias.TNTchannel.remove.error.not-specified");
            return;
        } else {
            int Id = channelToRemoveModel.getId();
            VlMedia tntchannel = (VlMedia)data.getMedia(Id);
            if (tntchannel == null)
            {
                arg1.rejectValue("Id",
                        "medias.TNTchannel.remove.error.nonexisting");
            }
            else
            {
                if (tntchannel.getProgram() != null)
                    arg1.rejectValue("name", "medias.TNTchannel.remove.error.cantremovewithaprogramm");
            }
        }

    }

}
