/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.common.medias;

import java.io.Serializable;

import org.videolan.vlma.common.programs.IVlProgram;

/**
 * Basic abstract implementation of IVlMedia.
 * 
 * @author SylV
 * 
 */
public abstract class VlMedia implements Serializable, IVlMedia {

    protected String name;

    protected String group;

    protected IVlProgram program;

    public IVlProgram getProgram() {
        return program;
    }

    public void setProgram(IVlProgram program) {
        this.program = program;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public boolean sameGroup(IVlMedia media) {
        return false;
    }

    public boolean belongsToGroup(VlMediaGroup group) {
        return false;
    }

}
