/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.daemon;

import java.io.File;
import java.net.URL;
import java.rmi.RemoteException;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.videolan.vlma.Data;
import org.videolan.vlma.daemon.Daemon;

public class VLMad {
    private static final Logger logger = Logger.getLogger(VLMad.class);
    public static final String CONFIGURATION_FILE = "config.properties";

    public static void usage() {
        System.out.println("Usage: java org.videolan.vlma.daemon.VLMad (start|reload|stop)");
    }

    public void dispatch(Command command) {
        if (command.equals((Object)Command.start)) {
            logger.debug((Object)"Starting VLMad");
            logger.debug((Object)"Loading Spring application context");
            ClassPathXmlApplicationContext ac = new ClassPathXmlApplicationContext("daemon.xml");
            Daemon daemon = (Daemon)ac.getBean("daemon");
            logger.debug((Object)"Registering shutdown hook");
            Runtime.getRuntime().addShutdownHook(new ShutdownHook(daemon));
            daemon.start();
        } else {
            try {
                ClassPathXmlApplicationContext ac = new ClassPathXmlApplicationContext("client.xml");
                Data data = (Data)ac.getBean("dataImporter");
                if (command.equals((Object)Command.stop)) {
                    data.stop();
                } else if (command.equals((Object)Command.reload)) {
                    data.reload();
                }
            }
            catch (RemoteException e) {
                System.err.println("[ERROR] Unable to contact VLMa daemon. Is it really running?");
                System.exit(1);
            }
            catch (BeanCreationException e) {
                System.err.println("[ERROR] Unable to contact VLMa daemon. Is it really running?");
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) {
        Command command = null;
        if (args.length == 0) {
            command = Command.start;
        } else {
            try {
                command = Command.valueOf(args[0]);
            }
            catch (IllegalArgumentException e) {
                System.out.println(args[0] + " is not a valid command.");
                VLMad.usage();
                System.exit(1);
            }
        }
        VLMad vlmad = new VLMad();
        vlmad.dispatch(command);
    }

    public static URL getDefaultConfigurationFile() {
        return Daemon.class.getResource("/config.properties");
    }

    private static File getUserConfFile() {
        String confDir = System.getProperty("vlma.conf");
        if (confDir == null) {
            confDir = System.getProperty("user.home") + File.separator + ".vlma";
        }
        File dir = new File(confDir);
        dir.mkdirs();
        return new File(dir, CONFIGURATION_FILE);
    }

    private static Configuration getUserConf(File f) throws ConfigurationException {
        PropertiesConfiguration configuration = new PropertiesConfiguration(f);
        configuration.setAutoSave(true);
        FileChangedReloadingStrategy reloadingStrategy = new FileChangedReloadingStrategy();
        reloadingStrategy.setConfiguration((FileConfiguration)configuration);
        configuration.setReloadingStrategy((ReloadingStrategy)reloadingStrategy);
        return configuration;
    }

    public static Configuration getUserConfiguration() {
        try {
            return VLMad.getUserConf(VLMad.getUserConfFile());
        }
        catch (ConfigurationException e) {
            logger.error((Object)"Unable to read configuration file. Modifications won't be saved.", (Throwable)e);
            return new BaseConfiguration();
        }
    }

    private class ShutdownHook
    extends Thread {
        private Daemon daemon;

        public ShutdownHook(Daemon daemon) {
            this.daemon = daemon;
        }

        public void run() {
            if (this.daemon.isRunning()) {
                this.daemon.stop();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Command {
        start,
        reload,
        stop;

    }
}

