/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.model;

import org.videolan.vlma.model.Media;

public class SatChannel
extends Media {
    private static final long serialVersionUID = -7184440663167160629L;
    private int frequency;
    private char polarisation;
    private int sid;
    private String fullname;
    private String country;
    private String category = "R-DIG";
    private String encryption;
    private int errorCorrection;
    private int symbolRate;
    private String coverage = "";
    public static final String DEFAULT_SAT_SAP_GROUP = "Satellite";
    public static final String DEFAULT_RADIO_SAP_GROUP = "Radio";

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getEncryption() {
        return this.encryption;
    }

    public void setEncryption(String encryption) {
        this.encryption = encryption;
    }

    public int getErrorCorrection() {
        return this.errorCorrection;
    }

    public void setErrorCorrection(int errorCorrection) {
        this.errorCorrection = errorCorrection;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public char getPolarisation() {
        return this.polarisation;
    }

    public void setPolarisation(char polarisation) {
        this.polarisation = polarisation;
    }

    public int getSid() {
        return this.sid;
    }

    public void setSid(int sid) {
        this.sid = sid;
    }

    public int getSymbolRate() {
        return this.symbolRate;
    }

    public void setSymbolRate(int symbolRate) {
        this.symbolRate = symbolRate;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getCoverage() {
        return this.coverage;
    }

    public void setCoverage(String coverage) {
        this.coverage = coverage;
    }

    public String getType() {
        return "DVB-S adapter";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(SatChannel.class)) {
            SatChannel c = (SatChannel)o;
            return c.getCoverage().equals(this.coverage) && c.getFrequency() == this.frequency && c.name.equals(this.name);
        }
        return false;
    }

    public boolean sameGroup(Media media) {
        if (media.getClass() == SatChannel.class) {
            SatChannel c = (SatChannel)media;
            return c.getCoverage().equals(this.coverage) && c.getFrequency() == this.frequency;
        }
        return false;
    }

    public int hashCode() {
        return this.frequency + this.coverage.hashCode() + this.name.hashCode();
    }

    public boolean getIsRadio() {
        return this.category.contains("R-DIG");
    }

    public boolean getIsCrypted() {
        return this.category.contains("CRYPT");
    }
}

