/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.util.HashMap;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdFileBackendFactory;
import org.jrobin.core.RrdMemoryBackendFactory;
import org.jrobin.core.RrdNioBackendFactory;

public abstract class RrdBackendFactory {
    private static final HashMap factories = new HashMap();
    private static RrdBackendFactory defaultFactory;

    public static synchronized RrdBackendFactory getFactory(String string) throws RrdException {
        RrdBackendFactory rrdBackendFactory = (RrdBackendFactory)factories.get(string);
        if (rrdBackendFactory != null) {
            return rrdBackendFactory;
        }
        throw new RrdException("No backend factory found with the name specified [" + string + "]");
    }

    public static synchronized void registerFactory(RrdBackendFactory rrdBackendFactory) throws RrdException {
        String string = rrdBackendFactory.getFactoryName();
        if (factories.containsKey(string)) {
            throw new RrdException("Backend factory of this name2 (" + string + ") already exists and cannot be registered");
        }
        factories.put(string, rrdBackendFactory);
    }

    public static synchronized void registerAndSetAsDefaultFactory(RrdBackendFactory rrdBackendFactory) throws RrdException {
        RrdBackendFactory.registerFactory(rrdBackendFactory);
        RrdBackendFactory.setDefaultFactory(rrdBackendFactory.getFactoryName());
    }

    public static RrdBackendFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static void setDefaultFactory(String string) throws RrdException {
        if (RrdBackend.getCount() != 0L) {
            throw new RrdException("Could not change the default backend factory. This method must be called before the first RRD gets created");
        }
        defaultFactory = RrdBackendFactory.getFactory(string);
    }

    protected abstract RrdBackend open(String var1, boolean var2, int var3) throws IOException;

    protected abstract boolean exists(String var1) throws IOException;

    public abstract String getFactoryName();

    static {
        try {
            RrdFileBackendFactory rrdFileBackendFactory = new RrdFileBackendFactory();
            RrdBackendFactory.registerFactory(rrdFileBackendFactory);
            RrdMemoryBackendFactory rrdMemoryBackendFactory = new RrdMemoryBackendFactory();
            RrdBackendFactory.registerFactory(rrdMemoryBackendFactory);
            RrdNioBackendFactory rrdNioBackendFactory = new RrdNioBackendFactory();
            RrdBackendFactory.registerFactory(rrdNioBackendFactory);
            defaultFactory = rrdNioBackendFactory;
        }
        catch (RrdException rrdException) {
            throw new RuntimeException("FATAL: Cannot register RRD backend factories: " + rrdException);
        }
    }
}

