/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.model;


/**
 * This class extends Media to represent a DTT channel.
 *
 * @author Cédric Venet
 */

public class DTTChannel extends Media {

    private static final long serialVersionUID = 5244679609690317161L;

    private int frequency;

    private int sid;

    /**
     * Gets the channel SID.
     *
     * @return the channel SID
     */
    public int getSid() {
        return sid;
    }

    /**
     * Sets the channel SID.
     *
     * @param sid
     *            the sid to set
     */
    public void setSid(int sid) {
        this.sid = sid;
    }

    /**
     * Gets the channel frequency.
     *
     * @return the channel frequency (kHz)
     */
    public int getFrequency() {
        return frequency;
    }

    /**
     * Sets the channel frequency.
     *
     * @param frequency
     *            the frequency to set (kHz)
     */
    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    @Override
    public String getType() {
        return Adapter.DTT;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) return false;
        if (o.getClass().equals(DTTChannel.class)) {
            DTTChannel c = (DTTChannel) o;
            return (c.getFrequency() == this.frequency && c.getSid() == sid
                    && c.name.equals(this.name));
        }
        return false;
    }

    @Override
    public boolean sameGroup(Media media) {
        if (media.getClass() == DTTChannel.class) {
            DTTChannel c = (DTTChannel) media;
            return (c.getFrequency() == this.frequency);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return frequency + name.hashCode();
    }

}
