/*******************************************************************************
* reader.h: Stream readers
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: reader.h,v 1.1 2001/10/06 21:23:36 bozo Exp $
*
* Authors: Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
* Common interface for stream readers (C_MpegReader) and implementation of a
* file stream reader (C_MpegFileReader).
*******************************************************************************/


#ifndef _MPEG_READER_H_
#define _MPEG_READER_H_


//------------------------------------------------------------------------------
// Constants
//------------------------------------------------------------------------------
#define MPEG_ENDOFSTREAM        FILE_EOF
#define MPEG_STREAMERROR        FILE_ERR


//------------------------------------------------------------------------------
// C_MpegReader class
//------------------------------------------------------------------------------
// Base class
//------------------------------------------------------------------------------
class C_MpegReader
{
public:
  C_MpegReader(C_Broadcast* pBroadcast);
  virtual ~C_MpegReader();

  virtual void Init() = 0;

  virtual int Read(byte* pBuff, int iSize) = 0;
  virtual int Seek(s64 iOffset, int bStartPos) = 0;
  virtual s64 Size() = 0;

  bool HasDiscontinuity()
  { return m_bDiscontinuity; };
  void ResetDiscontinuity()
  { m_bDiscontinuity = false; };

protected:
  C_Broadcast* m_pBroadcast;

  bool m_bDiscontinuity;
};


//------------------------------------------------------------------------------
// C_MpegFileReader class
//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
class C_MpegFileReader : public C_MpegReader 
{
public:
  C_MpegFileReader(C_Broadcast* pBroadcast);

  virtual void Init();

  virtual int Read(byte* pBuff, int iSize);
  virtual int Seek(s64 iOffset, int bStartPos);
  virtual s64 Size();

protected:
  C_File m_cFile;

  bool m_bLoop;
};

#else
#error "Multiple inclusions of reader.h"
#endif

